/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.image.DataBufferFloat;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReinterpretDescriptorTest {
    private RenderedOp sourceImage;

    @Test
    public void testLinearRescaleUShort() {
        RenderedOp targetImage = ReinterpretDescriptor.create((RenderedImage)this.sourceImage, (double)17.0, (double)11.0, (ScalingType)ReinterpretDescriptor.LINEAR, (InterpretationType)ReinterpretDescriptor.AWT, null);
        Assert.assertNotNull((Object)targetImage);
        Assert.assertEquals((long)5L, (long)targetImage.getWidth());
        Assert.assertEquals((long)5L, (long)targetImage.getHeight());
        Assert.assertEquals((long)4L, (long)targetImage.getSampleModel().getDataType());
        float[] targetData = ((DataBufferFloat)targetImage.getData().getDataBuffer()).getData();
        for (int i = 0; i < targetData.length; ++i) {
            Assert.assertEquals((String)("i = " + i), (double)130.0, (double)targetData[i], (double)0.0);
        }
    }

    @Test
    public void testTargetImageRenderingIsSameAsSourceImageRendering() {
        RenderedOp targetImage = ReinterpretDescriptor.create((RenderedImage)this.sourceImage, (double)1.0, (double)0.0, (ScalingType)ReinterpretDescriptor.LINEAR, (InterpretationType)ReinterpretDescriptor.AWT, null);
        Assert.assertSame((Object)this.sourceImage.getRendering(), (Object)targetImage.getRendering());
    }

    @Before
    public void setup() {
        this.sourceImage = ConstantDescriptor.create((Float)Float.valueOf(5.0f), (Float)Float.valueOf(5.0f), (Number[])new Short[]{(short)7}, null);
    }
}

