/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.compiler;

import com.bc.ceres.compiler.Band;
import com.bc.ceres.compiler.CodeMapper;
import com.bc.ceres.compiler.Product;
import java.io.File;
import java.text.MessageFormat;
import junit.framework.TestCase;

public final class CodeCompilerTest
extends TestCase {
    public void testIt() throws Exception {
        String pattern = "package com.bc.ceres.jai.opimage.exprc;\n\nimport static java.lang.Math.*;\n\npublic class {0} implements Function '{'\n\n{1}\n    public {0}(Product p) '{'\n{2}    }\n\n    public double eval(int _index) '{'\n{3}        return {4};\n    }\n}\n";
        Product p = new Product(new Band[]{new Band("b1", new double[]{1.0, 2.0, 3.0}), new Band("b2", new double[]{6.0, 7.0, 8.0})});
        String className = "TestFunction";
        String expression = "0.5 * (b1 + b2)";
        CodeMapper.CodeMapping codeMapping = CodeMapper.mapCode((CharSequence)expression, (CodeMapper.NameMapper)new CodeMapper.NameMapper(){

            public String mapName(String name) {
                return name;
            }
        });
        StringBuilder varDecl = new StringBuilder();
        StringBuilder varDef = new StringBuilder();
        StringBuilder deref = new StringBuilder();
        for (String s : codeMapping.getMappings().keySet()) {
            varDecl.append(String.format("    private final double[] a%s;\n", s));
            varDef.append(String.format("        a%s = p.getBand(\"%s\").getSamples();\n", s, s));
            deref.append(String.format("        final double %s = a%s[_index];\n", s, s));
        }
        String code = MessageFormat.format(pattern, className, varDecl.toString(), varDef.toString(), deref.toString(), expression);
        File outputDir = new File("./target/test-classes");
        File[] classPath = new File[]{new File("./target/classes"), new File("./target/test-classes")};
    }
}

