/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.jai.opimage.DFTConvolveRIF;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.KernelJAI;
import javax.media.jai.TiledImage;
import junit.framework.TestCase;

public class DFTConvolveRIFTest
extends TestCase {
    public void testKernelImage() {
        float sum = 45.0f;
        float[] data = new float[]{1.0f / sum, 2.0f / sum, 3.0f / sum, 4.0f / sum, 5.0f / sum, 6.0f / sum, 7.0f / sum, 8.0f / sum, 9.0f / sum};
        TiledImage image = DFTConvolveRIF.createKernelImage((RenderedImage)new BufferedImage(10, 10, 10), (int)4, (KernelJAI)new KernelJAI(3, 3, data));
        DFTConvolveRIFTest.assertEquals((int)10, (int)image.getWidth());
        DFTConvolveRIFTest.assertEquals((int)10, (int)image.getHeight());
        DFTConvolveRIFTest.assertEquals((float)(5.0f / sum), (float)image.getSampleFloat(0, 0, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(6.0f / sum), (float)image.getSampleFloat(1, 0, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(2, 0, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(8.0f / sum), (float)image.getSampleFloat(0, 1, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(9.0f / sum), (float)image.getSampleFloat(1, 1, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(2, 1, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(0, 2, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(1, 2, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(2, 2, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(8, 0, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(4.0f / sum), (float)image.getSampleFloat(9, 0, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(8, 1, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(7.0f / sum), (float)image.getSampleFloat(9, 1, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(8, 2, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(9, 2, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(0, 8, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(1, 8, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(2, 8, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(2.0f / sum), (float)image.getSampleFloat(0, 9, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(3.0f / sum), (float)image.getSampleFloat(1, 9, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(2, 9, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(8, 8, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(9, 8, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)0.0f, (float)image.getSampleFloat(8, 9, 0), (float)0.0f);
        DFTConvolveRIFTest.assertEquals((float)(1.0f / sum), (float)image.getSampleFloat(9, 9, 0), (float)0.0f);
    }

    public void testNextBase2Size() {
        DFTConvolveRIFTest.assertEquals((int)256, (int)DFTConvolveRIF.getNextBase2Size((int)256));
        DFTConvolveRIFTest.assertEquals((int)512, (int)DFTConvolveRIF.getNextBase2Size((int)257));
        DFTConvolveRIFTest.assertEquals((int)512, (int)DFTConvolveRIF.getNextBase2Size((int)512));
        DFTConvolveRIFTest.assertEquals((int)1024, (int)DFTConvolveRIF.getNextBase2Size((int)513));
        DFTConvolveRIFTest.assertEquals((int)1024, (int)DFTConvolveRIF.getNextBase2Size((int)578));
    }
}

