/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.GeneralFilterFunction;
import com.bc.ceres.jai.operator.GeneralFilterDescriptor;
import com.bc.ceres.jai.operator.SourceImageFactory;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Test;

public class GeneralFilterDescriptorTest {
    @Test
    public void testMax() {
        short[] sourceData = new short[]{0, 1, 2, 3, 4, 9, 0, 1, 2, 3, 8, 9, 0, 1, 2, 7, 8, 9, 0, 1, 6, 7, 8, 9, 0};
        short[] expectedData = new short[]{9, 9, 3, 4, 4, 9, 9, 9, 4, 4, 9, 9, 9, 9, 3, 9, 9, 9, 9, 9, 8, 9, 9, 9, 9};
        BufferedImage image = SourceImageFactory.createOneBandedUShortImage(5, 5, sourceData);
        BorderExtender borderExtender = BorderExtender.createInstance((int)0);
        GeneralFilterFunction.Max max = new GeneralFilterFunction.Max(3, 3, 1, 1, null);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)image, (GeneralFilterFunction)max, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testMedian() {
        short[] sourceData = new short[]{0, 1, 2, 3, 4, 9, 0, 1, 2, 3, 8, 9, 0, 1, 2, 7, 8, 9, 0, 1, 6, 7, 8, 9, 0};
        short[] expectedData = new short[]{0, 0, 1, 2, 0, 0, 1, 1, 2, 2, 7, 8, 1, 1, 1, 7, 8, 8, 1, 0, 0, 7, 7, 0, 0};
        BufferedImage image = SourceImageFactory.createOneBandedUShortImage(5, 5, sourceData);
        BorderExtender borderExtender = BorderExtender.createInstance((int)0);
        GeneralFilterFunction.Median median = new GeneralFilterFunction.Median(3, 3, 1, 1, null);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)image, (GeneralFilterFunction)median, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)1L, (long)op.getSampleModel().getDataType());
        DataBufferUShort destBuffer = (DataBufferUShort)op.getData().getDataBuffer();
        short[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)expectedData[i], (long)resultData[i]);
        }
    }

    @Test
    public void testMedian_WithNaNs() {
        float n = Float.NaN;
        float[] sourceData = new float[]{0.0f, 1.0f, 2.0f, n, 4.0f, 9.0f, 0.0f, 1.0f, 2.0f, 3.0f, 8.0f, 9.0f, 0.0f, n, 2.0f, 7.0f, n, 9.0f, 0.0f, 1.0f, n, 7.0f, 8.0f, 9.0f, 0.0f};
        float[] expectedData = new float[]{0.0f, 0.0f, 0.5f, 1.5f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, 2.0f, 3.5f, 7.5f, 1.0f, 1.5f, 0.5f, 7.0f, 8.0f, 8.0f, 1.5f, 0.0f, 0.0f, 7.0f, 3.5f, 0.0f, 0.0f};
        BufferedImage image = SourceImageFactory.createOneBandedFloatImage(5, 5, sourceData);
        BorderExtender borderExtender = BorderExtender.createInstance((int)0);
        GeneralFilterFunction.Median median = new GeneralFilterFunction.Median(3, 3, 1, 1, null);
        RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)image, (GeneralFilterFunction)median, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        Assert.assertNotNull((Object)op);
        Assert.assertEquals((long)5L, (long)op.getWidth());
        Assert.assertEquals((long)5L, (long)op.getHeight());
        Assert.assertEquals((long)4L, (long)op.getSampleModel().getDataType());
        DataBufferFloat destBuffer = (DataBufferFloat)op.getData().getDataBuffer();
        float[] resultData = destBuffer.getData();
        for (int i = 0; i < resultData.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (double)expectedData[i], (double)resultData[i], (double)1.0E-6);
        }
    }
}

