/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDataNature;
import javax.media.jai.operator.DFTDescriptor;
import javax.media.jai.operator.DFTScalingType;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.IDFTDescriptor;
import javax.media.jai.operator.MagnitudeDescriptor;
import javax.media.jai.operator.PhaseDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class DFTTestMain {
    private static int location;

    public static void main(String[] args) {
        BufferedImage src = args.length == 0 ? DFTTestMain.createTestImage(512, 512) : FileLoadDescriptor.create((String)args[0], null, (Boolean)false, null);
        RenderedOp dft = DFTDescriptor.create((RenderedImage)src, (DFTScalingType)DFTDescriptor.SCALING_NONE, (DFTDataNature)DFTDescriptor.REAL_TO_COMPLEX, null);
        RenderedOp idft = IDFTDescriptor.create((RenderedImage)dft, (DFTScalingType)DFTDescriptor.SCALING_DIMENSIONS, (DFTDataNature)DFTDescriptor.COMPLEX_TO_REAL, null);
        RenderedOp dftMagnitude = MagnitudeDescriptor.create((RenderedImage)dft, null);
        RenderedOp dftPhase = PhaseDescriptor.create((RenderedImage)dft, null);
        DFTTestMain.showImage(src, "Source");
        DFTTestMain.showImage((RenderedImage)DFTTestMain.rescale((RenderedImage)dftMagnitude, 0.0, 1000.0), "FFT Magnitude");
        DFTTestMain.showImage((RenderedImage)DFTTestMain.rescale((RenderedImage)dftPhase, -3.0, 3.0), "FFT Phase");
        DFTTestMain.showImage((RenderedImage)DFTTestMain.rescale((RenderedImage)idft, 0.0, 255.0), "Inverse FFT");
    }

    public static RenderedOp rescale(RenderedImage idft) {
        double[][] extrema = (double[][])ExtremaDescriptor.create((RenderedImage)idft, null, (Integer)1, (Integer)1, (Boolean)true, (Integer)1000, null).getProperty("extrema");
        double x1 = extrema[0][0];
        double x2 = extrema[1][0];
        System.out.println("extrema min = " + x1);
        System.out.println("extrema max = " + x2);
        return DFTTestMain.rescale(idft, x1, x2);
    }

    public static RenderedOp rescale(RenderedImage idft, double x1, double x2) {
        return FormatDescriptor.create((RenderedImage)DFTTestMain.rescale(idft, x1, x2, 0.0, 255.0), (Integer)0, null);
    }

    public static RenderedOp rescale(RenderedImage src, double x1, double x2, double y1, double y2) {
        double a = (y2 - y1) / (x2 - x1);
        double b = y1 - a * x1;
        return RescaleDescriptor.create((RenderedImage)FormatDescriptor.create((RenderedImage)src, (Integer)5, null), (double[])new double[]{a}, (double[])new double[]{b}, null);
    }

    public static void showImage(RenderedImage image, String name) {
        BufferedImage bufferedImage;
        int width = image.getWidth();
        int height = image.getHeight();
        int numBands = image.getSampleModel().getNumBands();
        int dataType = image.getSampleModel().getDataType();
        System.out.println("============= Image " + name);
        System.out.println("width = " + width);
        System.out.println("height = " + height);
        System.out.println("numBands = " + numBands);
        System.out.println("dataType = " + dataType);
        if (image instanceof PlanarImage) {
            PlanarImage planarImage = (PlanarImage)image;
            long t0 = System.nanoTime();
            bufferedImage = planarImage.getAsBufferedImage();
            long t1 = System.nanoTime();
            System.out.println("BufferedImage created in " + (double)(t1 - t0) / 1000000.0 + " ms");
        } else if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            throw new IllegalArgumentException("image");
        }
        JScrollPane scrollPane = new JScrollPane(new JLabel(new ImageIcon(bufferedImage)));
        scrollPane.setBorder(null);
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(3);
        frame.add(scrollPane);
        frame.pack();
        location = location + 24;
        frame.setLocation(location, location += 24);
        frame.setVisible(true);
    }

    public static BufferedImage createTestImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        double r = Math.PI * 2;
        int n0 = 5;
        int n = 3;
        double fu = 1.0;
        double fv = 1.0;
        double s = 1.0 / (double)n;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double u = r * (double)x / ((double)width - 1.0);
                double v = r * (double)y / ((double)height - 1.0);
                double w = 0.0;
                for (int k = n0; k < n0 + n; ++k) {
                    w += 0.5 * s * (Math.sin(fu * (double)k * u) + Math.sin(fv * (double)k * v));
                }
                w = 0.5 * (1.0 + w);
                data[y * width + x] = (byte)Math.floor(255.0 * w);
            }
        }
        return image;
    }
}

