/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.ClampDescriptor;
import javax.media.jai.operator.ConvolveDescriptor;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FileStoreDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.MultiplyDescriptor;
import javax.media.jai.operator.NotDescriptor;

public class ConvolveTestMain {
    public static void main(String[] args) {
        String sourceFile = args[0];
        int m = Integer.parseInt(args[1]);
        String format = sourceFile.substring(1 + sourceFile.lastIndexOf(46));
        String targetBase = sourceFile.substring(0, sourceFile.lastIndexOf(46));
        String targetFile0 = targetBase + "_" + m + "_0." + format;
        String targetFile1 = targetBase + "_" + m + "_1." + format;
        String targetFile2 = targetBase + "_" + m + "_2." + format;
        KernelJAI gaussKernel = ConvolveTestMain.createGaussianKernel(m);
        ConvolveTestMain.dumpKernelData("Gaussian", gaussKernel);
        KernelJAI distKernel = ConvolveTestMain.createDistancesKernel(m);
        ConvolveTestMain.dumpKernelData("Distances", distKernel);
        RenderedOp source = FileLoadDescriptor.create((String)sourceFile, null, (Boolean)true, null);
        source = BandSelectDescriptor.create((RenderedImage)source, (int[])new int[1], null);
        System.out.println("Writing " + targetFile0);
        FileStoreDescriptor.create((RenderedImage)source, (String)targetFile0, (String)format, null, (Boolean)false, null);
        long t1 = System.currentTimeMillis();
        System.out.println("Computing " + targetFile1);
        BorderExtender borderExtender = BorderExtender.createInstance((int)1);
        RenderedOp target1 = ConvolveDescriptor.create((RenderedImage)source, (KernelJAI)gaussKernel, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender));
        RenderedOp mask = ClampDescriptor.create((RenderedImage)source, (double[])new double[]{0.0}, (double[])new double[]{1.0}, null);
        mask = MultiplyConstDescriptor.create((RenderedImage)mask, (double[])new double[]{255.0}, null);
        mask = NotDescriptor.create((RenderedImage)mask, null);
        mask = ClampDescriptor.create((RenderedImage)mask, (double[])new double[]{0.0}, (double[])new double[]{1.0}, null);
        target1 = MultiplyDescriptor.create((RenderedImage)target1, (RenderedImage)mask, null);
        target1 = AddDescriptor.create((RenderedImage)target1, (RenderedImage)source, null);
        System.out.println("Writing " + targetFile1);
        FileStoreDescriptor.create((RenderedImage)target1, (String)targetFile1, (String)format, null, (Boolean)false, null);
        System.out.println("Done in " + (System.currentTimeMillis() - t1) + " ms");
        long t2 = System.currentTimeMillis();
        System.out.println("Computing " + targetFile2);
        BufferedImage target2 = ConvolveTestMain.convolveICOL(source, gaussKernel, distKernel);
        System.out.println("Writing " + targetFile2);
        FileStoreDescriptor.create((RenderedImage)target2, (String)targetFile2, (String)format, null, (Boolean)false, null);
        System.out.println("Done in " + (System.currentTimeMillis() - t2) + " ms");
    }

    private static BufferedImage convolveICOL(RenderedOp source, KernelJAI gaussKernel, KernelJAI distKernel) {
        int k;
        int m = gaussKernel.getWidth();
        int n = m / 2 + 1;
        float[] weights = new float[n];
        float wSum = 0.0f;
        for (k = 0; k < n; ++k) {
            weights[k] = gaussKernel.getElement(distKernel.getXOrigin() + k, distKernel.getYOrigin());
            wSum += weights[k];
        }
        k = 0;
        while (k < n) {
            int n2 = k++;
            weights[n2] = weights[n2] / wSum;
        }
        ConvolveTestMain.dumpArray("Weights", weights);
        int width = source.getWidth();
        int height = source.getHeight();
        Raster aRaster = source.getData(new Rectangle(0, 0, width, height));
        BufferedImage cImage = new BufferedImage(width, height, 10);
        byte[] aData = ((DataBufferByte)aRaster.getDataBuffer()).getData();
        byte[] cData = ((DataBufferByte)cImage.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int k2;
                float[] sums = new float[n];
                int[] counts = new int[n];
                for (int j = 0; j < m; ++j) {
                    for (int i = 0; i < m; ++i) {
                        int a;
                        k2 = (int)distKernel.getElement(i, j);
                        if (k2 <= 0) continue;
                        int xx = x + i - distKernel.getXOrigin();
                        int yy = y + j - distKernel.getYOrigin();
                        if (xx < 0 || xx >= width || yy < 0 || yy >= height || (a = aData[yy * width + xx] & 0xFF) <= 0) continue;
                        int n3 = k2;
                        sums[n3] = sums[n3] + (float)a;
                        int n4 = k2;
                        counts[n4] = counts[n4] + 1;
                    }
                }
                int a = aData[y * width + x] & 0xFF;
                float c = weights[0] * (float)a;
                for (k2 = 1; k2 < n; ++k2) {
                    if (counts[k2] <= 0) continue;
                    c += weights[k2] * sums[k2] / (float)counts[k2];
                }
                cData[y * width + x] = a == 0 ? (byte)c : aData[y * width + x];
            }
        }
        return cImage;
    }

    private static KernelJAI createGaussianKernel(int m) {
        double sig = 0.46;
        float[] kernelData = new float[m * m];
        float sum = 0.0f;
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < m; ++i) {
                float fz;
                double dx = 2.0 * ((double)i / ((double)m - 1.0) - 0.5);
                double dy = 2.0 * ((double)j / ((double)m - 1.0) - 0.5);
                double z = 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-0.5 * (dx * dx + dy * dy) / (sig * sig));
                kernelData[j * m + i] = fz = (float)z;
                sum += fz;
            }
        }
        int i = 0;
        while (i < kernelData.length) {
            int n = i++;
            kernelData[n] = kernelData[n] / sum;
        }
        return new KernelJAI(m, m, kernelData);
    }

    private static KernelJAI createDistancesKernel(int m) {
        float[] kernelData = new float[m * m];
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < m; ++i) {
                double dx = (double)i - 0.5 * (double)(m - 1);
                double dy = (double)j - 0.5 * (double)(m - 1);
                int z = (int)Math.sqrt(dx * dx + dy * dy);
                if (z > m / 2) continue;
                kernelData[j * m + i] = (int)Math.sqrt(dx * dx + dy * dy);
            }
        }
        return new KernelJAI(m, m, kernelData);
    }

    private static void dumpKernelData(String name, KernelJAI kernel) {
        float[] kernelData1 = kernel.getKernelData();
        int m = kernel.getWidth();
        float max = 0.0f;
        for (int i = 0; i < kernelData1.length; ++i) {
            max = Math.max(max, kernelData1[i]);
        }
        System.out.println(name + ":");
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < m; ++i) {
                System.out.print((int)(9.999f * kernelData1[j * m + i] / max));
            }
            System.out.println();
        }
    }

    private static void dumpArray(String name, float[] data) {
        int k;
        int n = data.length;
        float max = 0.0f;
        for (k = 0; k < n; ++k) {
            max = Math.max(max, data[k]);
        }
        System.out.println(name + ":");
        for (k = 0; k < n; ++k) {
            System.out.print((int)(9.999 * (double)data[k] / (double)max));
        }
        System.out.println();
    }
}

