/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.compiler;

import com.bc.ceres.compiler.CodeMapper;
import java.util.HashSet;
import junit.framework.TestCase;

public class CodeMapperTest
extends TestCase {
    public void testCodeMapper() {
        final HashSet<String> nameSet = new HashSet<String>();
        nameSet.add("b1");
        nameSet.add("b2");
        nameSet.add("b3");
        nameSet.add("b4");
        String expression = "b4 + sqrt(b1 * b1 + b2 * b2)";
        CodeMapper.NameMapper mapper = new CodeMapper.NameMapper(){

            public String mapName(String name) {
                return nameSet.contains(name) ? "_a" + name : null;
            }
        };
        CodeMapper.CodeMapping codeMapping = CodeMapper.mapCode((CharSequence)expression, (CodeMapper.NameMapper)mapper);
        CodeMapperTest.assertNotNull((Object)codeMapping);
        CodeMapperTest.assertEquals((String)"_ab4 + sqrt(_ab1 * _ab1 + _ab2 * _ab2)", (String)codeMapping.getMappedCode());
        CodeMapperTest.assertEquals((int)3, (int)codeMapping.getMappings().size());
        CodeMapperTest.assertEquals((String)"_ab1", (String)((String)codeMapping.getMappings().get("b1")));
        CodeMapperTest.assertEquals((String)"_ab2", (String)((String)codeMapping.getMappings().get("b2")));
        CodeMapperTest.assertEquals((String)"_ab4", (String)((String)codeMapping.getMappings().get("b4")));
    }
}

