/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.tilecache;

import java.awt.Image;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import javax.media.jai.CachedTile;

public final class MemoryTile
implements CachedTile {
    Raster tile;
    WeakReference owner;
    int tileX;
    int tileY;
    Object tileCacheMetric;
    long timeStamp;
    Object key;
    long tileSize;
    MemoryTile previous;
    MemoryTile next;
    int action = 0;

    MemoryTile(RenderedImage owner, int tileX, int tileY, Raster tile, Object tileCacheMetric) {
        this.owner = new WeakReference<RenderedImage>(owner);
        this.tile = tile;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileCacheMetric = tileCacheMetric;
        this.key = MemoryTile.hashKey(owner, tileX, tileY);
        DataBuffer db = tile.getDataBuffer();
        this.tileSize = (long)DataBuffer.getDataTypeSize(db.getDataType()) / 8L * (long)db.getSize() * (long)db.getNumBanks();
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public Object getKey() {
        return this.key;
    }

    public static Object hashKey(RenderedImage owner, int tileX, int tileY) {
        Object imageId = owner.getProperty("imageId");
        if (imageId == null || Image.UndefinedProperty.equals(imageId)) {
            return Integer.toHexString(owner.hashCode()) + "_" + tileX + "_" + tileY + "_" + owner.getClass().getName().replace('.', '_');
        }
        return Integer.toHexString(owner.hashCode()) + "_" + tileX + "_" + tileY + "_" + imageId;
    }

    public String toString() {
        RenderedImage o = this.getOwner();
        String ostring = o == null ? "null" : o.toString();
        Raster t = this.getTile();
        String tstring = t == null ? "null" : t.toString();
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + ostring + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + tstring + " key = " + this.getKeyAsString() + " tileSize = " + Long.toString(this.tileSize) + " timeStamp = " + Long.toString(this.timeStamp);
    }

    public String getKeyAsString() {
        if (this.key instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)this.key;
            return bigInteger.toString(16);
        }
        return this.key instanceof Long ? Long.toHexString((Long)this.key) : this.key.toString();
    }

    public Raster getTile() {
        return this.tile;
    }

    public RenderedImage getOwner() {
        return (RenderedImage)this.owner.get();
    }

    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public long getTileSize() {
        return this.tileSize;
    }

    public int getAction() {
        return this.action;
    }
}

