/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.VarSequenceType;
import com.bc.ceres.binio.internal.AbstractType;
import com.bc.ceres.core.Assert;
import java.io.IOException;

public abstract class VarElementCountSequenceType
extends AbstractType
implements VarSequenceType {
    private final String name;
    private final Type elementType;

    protected VarElementCountSequenceType(Type elementType) {
        this(elementType.getName() + "[]", elementType);
    }

    protected VarElementCountSequenceType(String name, Type elementType) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)elementType, (String)"elementType");
        this.name = name;
        this.elementType = elementType;
    }

    @Override
    public SequenceType resolve(CollectionData parent) throws IOException {
        int elementCount = this.resolveElementCount(parent);
        return TypeBuilder.SEQUENCE(this.elementType, elementCount);
    }

    protected abstract int resolveElementCount(CollectionData var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final int getSize() {
        return -1;
    }

    @Override
    public final Type getElementType() {
        return this.elementType;
    }

    @Override
    public final int getElementCount() {
        return -1;
    }

    @Override
    public final boolean isCollectionType() {
        return true;
    }

    @Override
    public final boolean isSequenceType() {
        return true;
    }
}

