/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractType;
import com.bc.ceres.core.Assert;

public final class SequenceTypeImpl
extends AbstractType
implements SequenceType {
    private final String name;
    private final Type elementType;
    private final int elementCount;
    private final int size;

    public SequenceTypeImpl(Type elementType, int elementCount) {
        Assert.notNull((Object)elementType, (String)"elementCount");
        Assert.argument((elementCount >= 0 ? 1 : 0) != 0, (String)"elementCount");
        this.name = elementType.getName() + "[" + elementCount + "]";
        this.elementType = elementType;
        this.elementCount = elementCount;
        this.size = elementCount * elementType.getSize();
    }

    @Override
    public final Type getElementType() {
        return this.elementType;
    }

    @Override
    public final int getElementCount() {
        return this.elementCount;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final boolean isCollectionType() {
        return true;
    }

    @Override
    public final boolean isSequenceType() {
        return true;
    }
}

