/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.util.TypeParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import junit.framework.TestCase;

public class TypeParserTest
extends TestCase {
    public void testSimpleCompound() throws IOException, ParseException {
        String code = "Point {  double x;  double y;  double z;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)1, (int)types.length);
        TypeParserTest.testPoint(types[0], (Type)SimpleType.DOUBLE);
    }

    public void testCompoundInCompound() throws IOException, ParseException {
        String code = "Point {  Complex x;  Complex y;  Complex z;}Complex {  double real;  double imag;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)2, (int)types.length);
        TypeParserTest.testPoint(types[0], (Type)types[1]);
        TypeParserTest.testComplex(types[1]);
        TypeParserTest.assertSame((Object)types[1], (Object)types[0].getMember(1).getType());
        TypeParserTest.assertSame((Object)types[1], (Object)types[0].getMember(1).getType());
        TypeParserTest.assertSame((Object)types[1], (Object)types[0].getMember(2).getType());
    }

    private static void testPoint(CompoundType type, Type memberType) {
        TypeParserTest.assertNotNull((Object)type);
        TypeParserTest.assertEquals((String)"Point", (String)type.getName());
        TypeParserTest.assertEquals((int)3, (int)type.getMemberCount());
        TypeParserTest.assertEquals((String)"x", (String)type.getMember(0).getName());
        TypeParserTest.assertEquals((String)"y", (String)type.getMember(1).getName());
        TypeParserTest.assertEquals((String)"z", (String)type.getMember(2).getName());
        TypeParserTest.assertSame((Object)memberType, (Object)type.getMember(0).getType());
        TypeParserTest.assertSame((Object)memberType, (Object)type.getMember(1).getType());
        TypeParserTest.assertSame((Object)memberType, (Object)type.getMember(2).getType());
    }

    private static void testComplex(CompoundType type) {
        TypeParserTest.assertEquals((String)"Complex", (String)type.getName());
        TypeParserTest.assertEquals((int)2, (int)type.getMemberCount());
        TypeParserTest.assertEquals((String)"real", (String)type.getMember(0).getName());
        TypeParserTest.assertEquals((String)"imag", (String)type.getMember(1).getName());
    }

    public void testSimpleFixSequence() throws IOException, ParseException {
        String code = "Scanline {  uint flags;  double[512] data;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)1, (int)types.length);
        TypeParserTest.testScanline(types[0]);
    }

    private static void testScanline(CompoundType type) {
        TypeParserTest.assertNotNull((Object)type);
        TypeParserTest.assertEquals((String)"Scanline", (String)type.getName());
        TypeParserTest.assertEquals((int)2, (int)type.getMemberCount());
        CompoundMember member1 = type.getMember(0);
        CompoundMember member2 = type.getMember(1);
        TypeParserTest.assertNotNull((Object)member1);
        TypeParserTest.assertNotNull((Object)member2);
        TypeParserTest.assertEquals((String)"flags", (String)member1.getName());
        TypeParserTest.assertSame((Object)SimpleType.UINT, (Object)member1.getType());
        TypeParserTest.assertEquals((String)"data", (String)member2.getName());
        TypeParserTest.assertTrue((boolean)(member2.getType() instanceof SequenceType));
        SequenceType sequenceType = (SequenceType)member2.getType();
        TypeParserTest.assertSame((Object)SimpleType.DOUBLE, (Object)sequenceType.getElementType());
        TypeParserTest.assertEquals((int)512, (int)sequenceType.getElementCount());
        TypeParserTest.assertEquals((int)4100, (int)type.getSize());
    }

    public void testSequenceOfSequences() throws IOException, ParseException {
        String code = "Matrix {  double[4][3] data;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)1, (int)types.length);
        TypeParserTest.testMatrix(types[0]);
    }

    private static void testMatrix(CompoundType type) {
        TypeParserTest.assertEquals((String)"Matrix", (String)type.getName());
        TypeParserTest.assertEquals((int)1, (int)type.getMemberCount());
        TypeParserTest.assertEquals((String)"data", (String)type.getMember(0).getName());
        TypeParserTest.assertTrue((boolean)(type.getMember(0).getType() instanceof SequenceType));
        SequenceType sequenceType = (SequenceType)type.getMember(0).getType();
        TypeParserTest.assertEquals((int)3, (int)sequenceType.getElementCount());
        TypeParserTest.assertTrue((boolean)(sequenceType.getElementType() instanceof SequenceType));
        SequenceType sequenceType2 = (SequenceType)sequenceType.getElementType();
        TypeParserTest.assertEquals((int)4, (int)sequenceType2.getElementCount());
        TypeParserTest.assertSame((Object)SimpleType.DOUBLE, (Object)sequenceType2.getElementType());
    }

    public void testSimpleVarSequenceWithReference() throws IOException, ParseException {
        String code = "Dataset {  int lineCount;  Scanline[lineCount] scanlines;}Scanline {  uint flags;  double[512] data;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)2, (int)types.length);
        CompoundType datasetType = types[0];
        CompoundType scanlineType = types[1];
        TypeParserTest.testDataset(datasetType, scanlineType, -1);
        TypeParserTest.testScanline(scanlineType);
    }

    public void testGrowableSequence() throws IOException, ParseException {
        String code = "Dataset {  int lineCount;  Scanline[] scanlines;}Scanline {  uint flags;  double[512] data;}";
        CompoundType[] types = TypeParserTest.parseTypes(code);
        TypeParserTest.assertNotNull((Object)types);
        TypeParserTest.assertEquals((int)2, (int)types.length);
        CompoundType datasetType = types[0];
        CompoundType scanlineType = types[1];
        TypeParserTest.testDataset(datasetType, scanlineType, 0);
        TypeParserTest.testScanline(scanlineType);
    }

    private static void testDataset(CompoundType datasetType, CompoundType scanlineType, int elementCount) {
        TypeParserTest.assertEquals((String)"Dataset", (String)datasetType.getName());
        TypeParserTest.assertEquals((int)2, (int)datasetType.getMemberCount());
        CompoundMember member1 = datasetType.getMember(0);
        CompoundMember member2 = datasetType.getMember(1);
        TypeParserTest.assertEquals((String)"lineCount", (String)member1.getName());
        TypeParserTest.assertSame((Object)SimpleType.INT, (Object)member1.getType());
        TypeParserTest.assertEquals((String)"scanlines", (String)member2.getName());
        TypeParserTest.assertTrue((boolean)(member2.getType() instanceof SequenceType));
        TypeParserTest.assertSame((Object)scanlineType, (Object)((SequenceType)member2.getType()).getElementType());
        TypeParserTest.assertEquals((int)elementCount, (int)((SequenceType)member2.getType()).getElementCount());
    }

    private static CompoundType[] parseTypes(String code) throws IOException, ParseException {
        StringReader reader = new StringReader(code);
        return TypeParser.parseUnit((Reader)reader);
    }
}

