/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.util.NumberUtils;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class NumberUtilsTest {
    @Test
    public void unsignedLongMaskBits() {
        byte[] bytes = NumberUtils.ULONG_MASK.toByteArray();
        Assert.assertEquals((long)9L, (long)bytes.length);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        Assert.assertEquals((long)255L, (long)(bytes[1] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[2] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[3] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[4] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[5] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[6] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[7] & 0xFF));
        Assert.assertEquals((long)255L, (long)(bytes[8] & 0xFF));
    }

    @Test
    public void bigIntegerFromUnsignedLongValue() {
        BigInteger unsignedLong = BigInteger.valueOf(-9223372036854747135L).and(NumberUtils.ULONG_MASK);
        byte[] bytes = unsignedLong.toByteArray();
        Assert.assertEquals((long)9L, (long)bytes.length);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        Assert.assertEquals((long)128L, (long)(bytes[1] & 0xFF));
        Assert.assertEquals((long)0L, (long)(bytes[2] & 0xFF));
        Assert.assertEquals((long)0L, (long)(bytes[3] & 0xFF));
        Assert.assertEquals((long)0L, (long)(bytes[4] & 0xFF));
        Assert.assertEquals((long)0L, (long)(bytes[5] & 0xFF));
        Assert.assertEquals((long)0L, (long)(bytes[6] & 0xFF));
        Assert.assertEquals((long)112L, (long)(bytes[7] & 0xFF));
        Assert.assertEquals((long)1L, (long)(bytes[8] & 0xFF));
    }
}

