/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.TracingIOHandler;
import com.bc.ceres.binio.smos.SmosProduct;
import com.bc.ceres.binio.util.ByteArrayIOHandler;
import java.io.IOException;
import java.nio.ByteOrder;
import junit.framework.TestCase;

public class SmosTest
extends TestCase {
    public void testSequentialProductReading() throws IOException {
        byte[] byteData = SmosProduct.createTestProductData(ByteOrder.LITTLE_ENDIAN);
        TracingIOHandler reader = new TracingIOHandler((IOHandler)new ByteArrayIOHandler(byteData));
        DataContext context = SmosProduct.MIR_SCLF1C_FORMAT.createContext((IOHandler)reader);
        CompoundData data = context.getData();
        SmosTest.assertEquals((long)0L, (long)data.getPosition());
        SmosTest.assertEquals((long)-1L, (long)data.getSize());
        SmosTest.assertEquals((String)"", (String)reader.getTrace());
        int snapshotCounter = data.getInt(0);
        SmosTest.assertEquals((int)3, (int)snapshotCounter);
        SmosTest.assertEquals((String)"R(0,4)", (String)reader.getTrace());
        SequenceData snapshotList = data.getSequence(1);
        SmosTest.assertNotNull((Object)snapshotList);
        SmosTest.assertNotNull((Object)snapshotList.getType());
        SmosTest.assertEquals((int)3, (int)snapshotList.getType().getElementCount());
        SmosTest.testSnapshotInfo(snapshotList, 0);
        SmosTest.testSnapshotInfo(snapshotList, 1);
        SmosTest.testSnapshotInfo(snapshotList, 2);
        SmosTest.assertEquals((String)"R(0,4)R(4,483)", (String)reader.getTrace());
        int gridPointCounter = data.getInt(2);
        SmosTest.assertEquals((int)4, (int)gridPointCounter);
        SmosTest.assertEquals((String)"R(0,4)R(4,483)R(487,4)", (String)reader.getTrace());
        SequenceData gridPointList = data.getSequence(3);
        SmosTest.assertNotNull((Object)gridPointList);
        SmosTest.assertNotNull((Object)gridPointList.getType());
        SmosTest.assertEquals((int)4, (int)gridPointList.getType().getElementCount());
        SmosTest.testGridPointData(gridPointList, 0);
        SmosTest.testGridPointData(gridPointList, 1);
        SmosTest.testGridPointData(gridPointList, 2);
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.assertEquals((String)"R(0,4)R(4,483)R(487,4)R(491,18)R(509,56)R(565,18)R(583,112)R(695,18)R(713,84)R(797,18)R(815,168)", (String)reader.getTrace());
        reader.reset();
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.assertEquals((String)"", (String)reader.getTrace());
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.assertEquals((String)"", (String)reader.getTrace());
        reader.reset();
        SmosTest.testGridPointData(gridPointList, 1);
        SmosTest.testGridPointData(gridPointList, 0);
        SmosTest.testGridPointData(gridPointList, 3);
        SmosTest.testGridPointData(gridPointList, 2);
        SmosTest.assertEquals((String)"R(565,18)R(583,112)R(491,18)R(509,56)R(797,18)R(815,168)", (String)reader.getTrace());
    }

    public void testRandomAccessProductReading() throws IOException {
        byte[] byteData = SmosProduct.createTestProductData(ByteOrder.LITTLE_ENDIAN);
        TracingIOHandler handler = new TracingIOHandler((IOHandler)new ByteArrayIOHandler(byteData));
        DataContext context = SmosProduct.MIR_SCLF1C_FORMAT.createContext((IOHandler)handler);
        CompoundData data = context.getData();
        SequenceData gridPointList = data.getSequence(3);
        SmosTest.assertNotNull((Object)gridPointList);
        SmosTest.assertNotNull((Object)gridPointList.getType());
        SmosTest.assertEquals((int)4, (int)gridPointList.getType().getElementCount());
        SmosTest.testGridPointData(gridPointList, 2);
        SmosTest.assertEquals((String)"R(0,4)R(487,4)R(491,18)R(565,18)R(695,18)R(713,84)", (String)handler.getTrace());
    }

    private static void testSnapshotInfo(SequenceData snapshotList, int i) throws IOException {
        int[] expectedTime = SmosProduct.getSnapshotTime(i);
        int expectedId = SmosProduct.getSnapshotId(i);
        CompoundData snapshotData = snapshotList.getCompound(i);
        SequenceData timeData = snapshotData.getSequence(0);
        SmosTest.assertEquals((int)expectedTime[0], (int)timeData.getInt(0));
        SmosTest.assertEquals((int)expectedTime[1], (int)timeData.getInt(1));
        SmosTest.assertEquals((int)expectedTime[2], (int)timeData.getInt(2));
        SmosTest.assertEquals((int)expectedId, (int)snapshotData.getInt(1));
        int expectedSize = SmosProduct.SNAPSHOT_INFO_TYPE.getSize();
        long expectedOffset = snapshotList.getPosition() + (long)i * snapshotData.getSize();
        SmosTest.assertEquals((long)expectedSize, (long)snapshotData.getSize());
        SmosTest.assertEquals((long)expectedOffset, (long)snapshotData.getPosition());
    }

    private static void testGridPointData(SequenceData gridPointList, int i) throws IOException {
        CompoundData gridPointData = gridPointList.getCompound(i);
        SmosTest.assertEquals((int)SmosProduct.getGridPointId(i), (int)gridPointData.getInt(0));
        SmosTest.assertEquals((float)SmosProduct.getGridPointLatitude(i), (float)gridPointData.getFloat(1), (float)1.0E-6f);
        SmosTest.assertEquals((float)SmosProduct.getGridPointLongitude(i), (float)gridPointData.getFloat(2), (float)1.0E-6f);
        SequenceData btDataList = gridPointData.getSequence(6);
        SmosTest.assertEquals((int)SmosProduct.BT_DATA_COUNTERS[i], (int)btDataList.getElementCount());
        for (int j = 0; j < SmosProduct.BT_DATA_COUNTERS[i]; ++j) {
            CompoundData btData = btDataList.getCompound(j);
            SmosTest.assertEquals((int)SmosProduct.getBtDataFlags(j), (int)btData.getShort("Flags"));
            SmosTest.assertEquals((Object)Float.valueOf(SmosProduct.getBtValueReal(j)), (Object)Float.valueOf(btData.getFloat("BT_Value_Real")));
            SmosTest.assertEquals((Object)Float.valueOf(SmosProduct.getBtValueImag(j)), (Object)Float.valueOf(btData.getFloat("BT_Value_Imag")));
        }
        long size = gridPointData.getSize();
        if (size >= 0L) {
            int expectedSize = 18 + SmosProduct.BT_DATA_COUNTERS[i] * SmosProduct.F1C_BT_DATA_TYPE.getSize();
            SmosTest.assertEquals((long)expectedSize, (long)size);
        }
    }
}

