/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.CompoundMemberImpl;
import com.bc.ceres.binio.internal.CompoundTypeImpl;
import com.bc.ceres.binio.internal.GrowableSequenceTypeImpl;
import junit.framework.TestCase;

public class CompoundTypeImplTest
extends TestCase {
    static final CompoundType COMPLEX = new CompoundTypeImpl("Complex", (CompoundMember[])new CompoundMemberImpl[]{new CompoundMemberImpl("real", (Type)SimpleType.DOUBLE), new CompoundMemberImpl("imag", (Type)SimpleType.DOUBLE)});
    static final CompoundType RECORD_TYPE = new CompoundTypeImpl("Record", (CompoundMember[])new CompoundMemberImpl[]{new CompoundMemberImpl("id", (Type)SimpleType.USHORT), new CompoundMemberImpl("flags", (Type)SimpleType.UINT), new CompoundMemberImpl("x", (Type)SimpleType.DOUBLE), new CompoundMemberImpl("y", (Type)SimpleType.DOUBLE), new CompoundMemberImpl("z", (Type)COMPLEX)});
    static final CompoundType DATASET_TYPE = new CompoundTypeImpl("Dataset", (CompoundMember[])new CompoundMemberImpl[]{new CompoundMemberImpl("recordCount", (Type)SimpleType.INT), new CompoundMemberImpl("records", (Type)new GrowableSequenceTypeImpl((Type)RECORD_TYPE))});

    public void testCompoundTypes() {
        CompoundType rt = RECORD_TYPE;
        CompoundTypeImplTest.assertEquals((String)"Record", (String)rt.getName());
        CompoundTypeImplTest.assertEquals((int)38, (int)rt.getSize());
        CompoundTypeImplTest.assertEquals((int)5, (int)rt.getMemberCount());
        CompoundTypeImplTest.assertEquals((Object)SimpleType.USHORT, (Object)rt.getMemberType(0));
        CompoundTypeImplTest.assertEquals((Object)SimpleType.UINT, (Object)rt.getMemberType(1));
        CompoundTypeImplTest.assertEquals((Object)SimpleType.DOUBLE, (Object)rt.getMemberType(2));
        CompoundTypeImplTest.assertEquals((Object)SimpleType.DOUBLE, (Object)rt.getMemberType(3));
        CompoundTypeImplTest.assertEquals((Object)COMPLEX, (Object)rt.getMemberType(4));
        CompoundTypeImplTest.assertEquals((int)-1, (int)rt.getMemberIndex("ID"));
        CompoundTypeImplTest.assertEquals((int)0, (int)rt.getMemberIndex("id"));
        CompoundTypeImplTest.assertEquals((int)1, (int)rt.getMemberIndex("flags"));
        CompoundTypeImplTest.assertEquals((int)2, (int)rt.getMemberIndex("x"));
        CompoundTypeImplTest.assertEquals((int)3, (int)rt.getMemberIndex("y"));
        CompoundTypeImplTest.assertEquals((int)4, (int)rt.getMemberIndex("z"));
        CompoundType dst = DATASET_TYPE;
        CompoundTypeImplTest.assertEquals((String)"Dataset", (String)dst.getName());
        CompoundTypeImplTest.assertEquals((int)4, (int)dst.getSize());
        CompoundTypeImplTest.assertEquals((int)2, (int)dst.getMemberCount());
        CompoundTypeImplTest.assertEquals((Object)SimpleType.INT, (Object)dst.getMemberType(0));
        CompoundTypeImplTest.assertEquals((int)-1, (int)dst.getMemberIndex("recordcount"));
        CompoundTypeImplTest.assertEquals((int)0, (int)dst.getMemberIndex("recordCount"));
        CompoundTypeImplTest.assertEquals((int)1, (int)dst.getMemberIndex("records"));
    }
}

