/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio;

import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.util.FilterIOHandler;
import java.io.IOException;

public class TracingIOHandler
extends FilterIOHandler {
    private final StringBuilder trace = new StringBuilder(512);

    public TracingIOHandler(IOHandler ioHandler) {
        super(ioHandler);
    }

    public void reset() {
        this.trace.setLength(0);
    }

    public String getTrace() {
        return this.trace.toString();
    }

    public void read(DataContext context, byte[] data, long position) throws IOException {
        this.trace.append("R(").append(position).append(",").append(data.length).append(")");
        this.getDelegate().read(context, data, position);
    }

    public void write(DataContext context, byte[] data, long position) throws IOException {
        this.trace.append("W(").append(position).append(",").append(data.length).append(")");
        this.getDelegate().write(context, data, position);
    }

    public String toString() {
        return this.getTrace();
    }
}

