/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.TracingIOHandler;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.util.ByteArrayIOHandler;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class ReadWriteTest
extends TestCase {
    protected void setUp() throws Exception {
        new File("test.dat").delete();
    }

    protected void tearDown() throws Exception {
        new File("test.dat").delete();
    }

    public void testFixCompound() throws IOException {
        CompoundType type = TypeBuilder.COMPOUND((String)"Complex", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"y", (Type)TypeBuilder.DOUBLE)});
        ByteArrayIOHandler byteArrayIOHandler = new ByteArrayIOHandler();
        TracingIOHandler tracingIOHandler = new TracingIOHandler((IOHandler)byteArrayIOHandler);
        DataContext context = new DataFormat(type).createContext((IOHandler)tracingIOHandler);
        CompoundData complex = context.getData();
        complex.setDouble("x", 23.04);
        complex.setDouble("y", 10.12);
        complex.flush();
        ReadWriteTest.assertEquals((String)"R(0,16)W(0,16)", (String)tracingIOHandler.getTrace());
        tracingIOHandler.reset();
        ReadWriteTest.assertEquals((double)23.04, (double)complex.getDouble("x"), (double)1.0E-10);
        ReadWriteTest.assertEquals((double)10.12, (double)complex.getDouble("y"), (double)1.0E-10);
        ReadWriteTest.assertEquals((String)"", (String)tracingIOHandler.getTrace());
        byte[] byteData = byteArrayIOHandler.toByteArray();
        byteArrayIOHandler = new ByteArrayIOHandler(byteData);
        tracingIOHandler = new TracingIOHandler((IOHandler)byteArrayIOHandler);
        context = new DataFormat(type).createContext((IOHandler)tracingIOHandler);
        complex = context.getData();
        ReadWriteTest.assertEquals((double)23.04, (double)complex.getDouble("x"), (double)1.0E-10);
        ReadWriteTest.assertEquals((double)10.12, (double)complex.getDouble("y"), (double)1.0E-10);
        ReadWriteTest.assertEquals((String)"R(0,16)", (String)tracingIOHandler.getTrace());
    }

    public void testCompoundWithFixSequenceOfFixCompounds() throws IOException {
        CompoundData complex;
        int i;
        CompoundType type = TypeBuilder.COMPOUND((String)"Data", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Complex_List", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.COMPOUND((String)"Complex", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"y", (Type)TypeBuilder.DOUBLE)}), (int)5))});
        ByteArrayIOHandler byteArrayIOHandler = new ByteArrayIOHandler();
        TracingIOHandler tracingIOHandler = new TracingIOHandler((IOHandler)byteArrayIOHandler);
        DataContext context = new DataFormat(type).createContext((IOHandler)tracingIOHandler);
        CompoundData data = context.getData();
        SequenceData seq = data.getSequence("Complex_List");
        for (i = 0; i < 5; ++i) {
            complex = seq.getCompound(i);
            complex.setDouble("x", (double)i + 23.04);
            complex.setDouble("y", (double)i + 10.12);
            complex.flush();
        }
        ReadWriteTest.assertEquals((String)"R(0,16)W(0,16)R(16,16)W(16,16)R(32,16)W(32,16)R(48,16)W(48,16)R(64,16)W(64,16)", (String)tracingIOHandler.getTrace());
        tracingIOHandler.reset();
        for (i = 0; i < 5; ++i) {
            complex = seq.getCompound(i);
            ReadWriteTest.assertEquals((double)((double)i + 23.04), (double)complex.getDouble("x"), (double)1.0E-10);
            ReadWriteTest.assertEquals((double)((double)i + 10.12), (double)complex.getDouble("y"), (double)1.0E-10);
        }
        ReadWriteTest.assertEquals((String)"R(0,16)R(16,16)R(32,16)R(48,16)R(64,16)", (String)tracingIOHandler.getTrace());
        byte[] byteData = byteArrayIOHandler.toByteArray();
        byteArrayIOHandler = new ByteArrayIOHandler(byteData);
        tracingIOHandler = new TracingIOHandler((IOHandler)byteArrayIOHandler);
        context = new DataFormat(type).createContext((IOHandler)tracingIOHandler);
        data = context.getData();
        seq = data.getSequence("Complex_List");
        for (int i2 = 0; i2 < 5; ++i2) {
            CompoundData complex2 = seq.getCompound(i2);
            ReadWriteTest.assertEquals((double)((double)i2 + 23.04), (double)complex2.getDouble("x"), (double)1.0E-10);
            ReadWriteTest.assertEquals((double)((double)i2 + 10.12), (double)complex2.getDouble("y"), (double)1.0E-10);
        }
        ReadWriteTest.assertEquals((String)"R(0,16)R(16,16)R(32,16)R(48,16)R(64,16)", (String)tracingIOHandler.getTrace());
    }

    public void testWriteVarSequence() throws IOException {
        CompoundType type = TypeBuilder.COMPOUND((String)"Data", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Counter", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"Complex_List", (Type)TypeBuilder.VAR_SEQUENCE((Type)TypeBuilder.COMPOUND((String)"Complex", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"y", (Type)TypeBuilder.DOUBLE)}), (String)"Counter"))});
        ByteArrayIOHandler byteArrayIOHandler = new ByteArrayIOHandler();
        TracingIOHandler tracingIOHandler = new TracingIOHandler((IOHandler)byteArrayIOHandler);
        DataContext context = new DataFormat(type).createContext((IOHandler)tracingIOHandler);
        CompoundData data = context.getData();
        data.setInt("Counter", -1);
        SequenceData seq = data.getSequence("Complex_List");
        ReadWriteTest.assertEquals((int)0, (int)seq.getElementCount());
        ReadWriteTest.assertEquals((long)0L, (long)seq.getSize());
        data.flush();
        ReadWriteTest.assertEquals((String)"R(0,4)W(0,4)", (String)tracingIOHandler.getTrace());
    }
}

