/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import junit.framework.TestCase;

public class FormatTest
extends TestCase {
    public void testBasisFormat() {
        DataFormat basisFormat = new DataFormat();
        DataFormat format = new DataFormat();
        FormatTest.assertNull((Object)format.getBasisFormat());
        format.setBasisFormat(basisFormat);
        FormatTest.assertSame((Object)basisFormat, (Object)format.getBasisFormat());
        basisFormat.addTypeDef("string80", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.BYTE, (int)80));
        FormatTest.assertTrue((boolean)format.isTypeDef("string80"));
        FormatTest.assertTrue((format.getTypeDef("string80") == basisFormat.getTypeDef("string80") ? 1 : 0) != 0);
        format.addTypeDef("string80", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.USHORT, (int)80));
        FormatTest.assertTrue((boolean)format.isTypeDef("string80"));
        FormatTest.assertTrue((format.getTypeDef("string80") != basisFormat.getTypeDef("string80") ? 1 : 0) != 0);
        format.removeTypeDef("string80");
        FormatTest.assertTrue((boolean)format.isTypeDef("string80"));
        FormatTest.assertTrue((format.getTypeDef("string80") == basisFormat.getTypeDef("string80") ? 1 : 0) != 0);
        basisFormat.removeTypeDef("string80");
        FormatTest.assertFalse((boolean)format.isTypeDef("string80"));
    }

    public void testTypeDef() {
        DataFormat format = new DataFormat(TypeBuilder.COMPOUND((String)"Point", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)SimpleType.FLOAT), TypeBuilder.MEMBER((String)"y", (Type)SimpleType.FLOAT)}));
        FormatTest.assertEquals((boolean)false, (boolean)format.isTypeDef("bool"));
        try {
            format.getTypeDef("bool");
            FormatTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        format.addTypeDef("bool", (Type)SimpleType.BYTE);
        FormatTest.assertSame((Object)SimpleType.BYTE, (Object)format.getTypeDef("bool"));
        FormatTest.assertEquals((boolean)true, (boolean)format.isTypeDef("bool"));
        FormatTest.assertEquals((boolean)false, (boolean)format.isTypeDef("ui32"));
        format.addTypeDef("ui32", (Type)SimpleType.UINT);
        FormatTest.assertSame((Object)SimpleType.UINT, (Object)format.getTypeDef("ui32"));
        FormatTest.assertSame((Object)SimpleType.BYTE, (Object)format.getTypeDef("bool"));
        format.addTypeDef("bool", (Type)SimpleType.BYTE);
        try {
            format.addTypeDef("bool", (Type)SimpleType.SHORT);
            FormatTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Type type = format.removeTypeDef("bool");
        FormatTest.assertSame((Object)SimpleType.BYTE, (Object)type);
        FormatTest.assertEquals((boolean)false, (boolean)format.isTypeDef("bool"));
        format.addTypeDef("bool", (Type)SimpleType.BYTE);
        FormatTest.assertEquals((boolean)true, (boolean)format.isTypeDef("bool"));
    }
}

