/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class DefaultDomConverterTest {
    private static final PropertyDescriptorFactory PROPERTY_DESCRIPTOR_FACTORY = new PropertyDescriptorFactory(){

        public PropertyDescriptor createValueDescriptor(Field field) {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), field.getType());
            X xAnnotation = field.getAnnotation(X.class);
            if (xAnnotation != null) {
                descriptor.setAlias(xAnnotation.alias());
                descriptor.setItemAlias(xAnnotation.itemAlias());
                if (xAnnotation.defaultValue() != null && !xAnnotation.defaultValue().isEmpty()) {
                    try {
                        descriptor.setDefaultConverter();
                        descriptor.setDefaultValue(descriptor.getConverter().parse(xAnnotation.defaultValue()));
                    }
                    catch (ConversionException e) {
                        throw new IllegalStateException("Failed to convert default value.", e);
                    }
                }
                if (xAnnotation.domConverter() != DomConverter.class) {
                    DomConverter domConverter;
                    try {
                        domConverter = xAnnotation.domConverter().newInstance();
                    }
                    catch (Throwable t) {
                        throw new IllegalStateException("Failed to create domConverter.", t);
                    }
                    descriptor.setDomConverter(domConverter);
                }
            }
            return descriptor;
        }
    };

    @Test
    public void testUnknownElement() throws Exception {
        String xml = "<parameters>  <kornField>42</kornField></parameters>";
        XppDom dom = this.createDom("<parameters>  <kornField>42</kornField></parameters>");
        SimplePojo value = new SimplePojo();
        try {
            DefaultDomConverterTest.convertDomToValue(dom, value);
            Assert.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void testDomToSimplePojo() throws Exception {
        String xml = "<parameters>  <fileField>C:/data/MER.N1</fileField>  <stringField>a string</stringField>  <intField>42</intField>  <doubleArrayField>1.2, 4.5, -0.034</doubleArrayField></parameters>";
        XppDom dom = this.createDom("<parameters>  <fileField>C:/data/MER.N1</fileField>  <stringField>a string</stringField>  <intField>42</intField>  <doubleArrayField>1.2, 4.5, -0.034</doubleArrayField></parameters>");
        SimplePojo value = new SimplePojo();
        Assert.assertEquals((long)0L, (long)value.intField);
        Assert.assertEquals(null, (Object)value.stringField);
        Assert.assertNull((Object)value.doubleArrayField);
        Assert.assertNull((Object)value.fileField);
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertEquals((long)42L, (long)value.intField);
        Assert.assertEquals((Object)"a string", (Object)value.stringField);
        Assert.assertEquals((Object)new File("C:/data/MER.N1"), (Object)value.fileField);
        Assert.assertNotNull((Object)value.doubleArrayField);
        Assert.assertEquals((long)3L, (long)value.doubleArrayField.length);
        Assert.assertEquals((double)1.2, (double)value.doubleArrayField[0], (double)1.0E-10);
        Assert.assertEquals((double)4.5, (double)value.doubleArrayField[1], (double)1.0E-10);
        Assert.assertEquals((double)-0.034, (double)value.doubleArrayField[2], (double)1.0E-10);
    }

    @Test
    public void testSimplePojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <fileField>" + new File("C:/data/dat.ini") + "</fileField>\n  <stringField>This is a test.</stringField>\n  <intField>43</intField>\n  <doubleArrayField>0.1,0.2,-0.4</doubleArrayField>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        SimplePojo value = new SimplePojo();
        value.intField = 43;
        value.stringField = "This is a test.";
        value.doubleArrayField = new double[]{0.1, 0.2, -0.4};
        value.fileField = new File("C:/data/dat.ini");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)expectedXml, (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testSimplePojoWithNullArrayToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <fileField>" + new File("C:/data/dat.ini") + "</fileField>\n  <stringField>This is a test.</stringField>\n  <intField>43</intField>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        SimplePojo value = new SimplePojo();
        value.intField = 43;
        value.stringField = "This is a test.";
        value.doubleArrayField = null;
        value.fileField = new File("C:/data/dat.ini");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)expectedXml, (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testSimplePojoWithNullObjectToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <stringField>This is a test.</stringField>\n  <intField>43</intField>\n  <doubleArrayField>0.1,0.2,-0.4</doubleArrayField>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        SimplePojo value = new SimplePojo();
        value.intField = 43;
        value.stringField = "This is a test.";
        value.doubleArrayField = new double[]{0.1, 0.2, -0.4};
        value.fileField = null;
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <stringField>This is a test.</stringField>\n  <intField>43</intField>\n  <doubleArrayField>0.1,0.2,-0.4</doubleArrayField>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testArrayInitIfAlreadyInitialized() throws Exception {
        String parameters = "<parameters>\n  <targetBands>\n    <band>band_a</band>\n    <band>band_b</band>\n    <band>band_c</band>\n  </targetBands>\n  <targetBand>notImportant</targetBand>\n  <defaultBandName>ignored</defaultBandName>\n</parameters>";
        XppDom dom = this.createDom("<parameters>\n  <targetBands>\n    <band>band_a</band>\n    <band>band_b</band>\n    <band>band_c</band>\n  </targetBands>\n  <targetBand>notImportant</targetBand>\n  <defaultBandName>ignored</defaultBandName>\n</parameters>");
        AnnotatedPojo annotatedPojo = new AnnotatedPojo();
        annotatedPojo.targetBandNames = new String[]{"band_1", "band_2"};
        DefaultDomConverterTest.convertDomToValue(dom, annotatedPojo);
        Assert.assertArrayEquals((Object[])new String[]{"band_a", "band_b", "band_c"}, (Object[])annotatedPojo.targetBandNames);
    }

    @Test
    public void testArrayWithDomConverterPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <allies>\n    <member>\n      <name>bibo</name>\n    </member>\n    <member>\n      <name>mimi</name>\n    </member>\n  </allies>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        ArrayWithDomConverterPojo value = new ArrayWithDomConverterPojo();
        value.allies = new Member[2];
        value.allies[0] = new Member("bibo");
        value.allies[1] = new Member("mimi");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <allies>\n    <member>\n      <name>bibo</name>\n    </member>\n    <member>\n      <name>mimi</name>\n    </member>\n  </allies>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testArrayWithDomConverterPojoToDom_NullValue() throws ValidationException, ConversionException {
        String expectedXml = "<parameters/>";
        XppDom dom = new XppDom("parameters");
        ArrayWithDomConverterPojo value = new ArrayWithDomConverterPojo();
        value.allies = null;
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters/>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testWeirdPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <weird/>\n  <name>ernie</name>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        WeirdPojo value = new WeirdPojo();
        value.weird = new Weird();
        value.name = "ernie";
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <weird/>\n  <name>ernie</name>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToArrayPojo() throws ConversionException {
        String expectedXml = "<parameters>\n  <fileField>" + new File("C:/data/dat.ini") + "</fileField>\n  <stringField>This is a test.</stringField>\n  <intField>43</intField>\n  <doubleArrayField>0.1,0.2,-0.4</doubleArrayField>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        SimplePojo value = new SimplePojo();
        value.intField = 43;
        value.stringField = "This is a test.";
        value.doubleArrayField = new double[]{0.1, 0.2, -0.4};
        value.fileField = new File("C:/data/dat.ini");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)expectedXml, (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testArrayPojoToDom() throws ConversionException {
        ConverterRegistry.getInstance().setConverter(Member.class, (Converter)new Converter<Member>(){

            public Class<? extends Member> getValueType() {
                return Member.class;
            }

            public Member parse(String text) throws ConversionException {
                return new Member(text);
            }

            public String format(Member field) {
                return field.name;
            }
        });
        String expectedXml = "<parameters>\n  <prince>bert</prince>\n  <allies>bibo,mimi</allies>\n</parameters>";
        XppDom dom = new XppDom("parameters");
        ArrayPojo arrayPojo = new ArrayPojo();
        arrayPojo.prince = new Member("bert");
        arrayPojo.allies = new Member[2];
        arrayPojo.allies[0] = new Member("bibo");
        arrayPojo.allies[1] = new Member("mimi");
        DefaultDomConverterTest.convertValueToDom(arrayPojo, dom);
        Assert.assertEquals((Object)"<parameters>\n  <prince>bert</prince>\n  <allies>bibo,mimi</allies>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToAnnotatedPojo() throws Exception {
        String xml = "<parameters>  <targetBand>result</targetBand>  <targetBands>    <band>a</band>    <band>b</band>  </targetBands></parameters>";
        XppDom dom = this.createDom("<parameters>  <targetBand>result</targetBand>  <targetBands>    <band>a</band>    <band>b</band>  </targetBands></parameters>");
        AnnotatedPojo value = new AnnotatedPojo();
        Assert.assertNull((Object)value.targetBandName);
        Assert.assertNull((Object)value.targetBandNames);
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertEquals((Object)"result", (Object)value.targetBandName);
        Assert.assertNotNull((Object)value.targetBandNames);
        Assert.assertEquals((long)2L, (long)value.targetBandNames.length);
        Assert.assertEquals((Object)"a", (Object)value.targetBandNames[0]);
        Assert.assertEquals((Object)"b", (Object)value.targetBandNames[1]);
    }

    @Test
    public void testAnnotatedPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <targetBand>radiance_13</targetBand>\n  <defaultBandName>radiance_12</defaultBandName>\n  <targetBands>\n    <band>u</band>\n    <band>v</band>\n    <band>w</band>\n  </targetBands>\n</parameters>";
        AnnotatedPojo value = new AnnotatedPojo();
        value.targetBandName = "radiance_13";
        value.defaultBandName = "radiance_12";
        value.targetBandNames = new String[]{"u", "v", "w"};
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <targetBand>radiance_13</targetBand>\n  <defaultBandName>radiance_12</defaultBandName>\n  <targetBands>\n    <band>u</band>\n    <band>v</band>\n    <band>w</band>\n  </targetBands>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToEnumPojo() throws Exception {
        String xml = "<parameters>  <character>KERMIT</character></parameters>";
        XppDom dom = this.createDom("<parameters>  <character>KERMIT</character></parameters>");
        EnumPojo value = new EnumPojo();
        Assert.assertNull((Object)((Object)value.character));
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertEquals((Object)((Object)EnumPojo.Muppet.KERMIT), (Object)((Object)value.character));
    }

    @Test
    public void testEnumPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <character>MISS_PIGGY</character>\n</parameters>";
        EnumPojo value = new EnumPojo();
        value.character = EnumPojo.Muppet.MISS_PIGGY;
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <character>MISS_PIGGY</character>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToComplexPojo() throws Exception {
        String xmlString = "<parameters>  <simple>    <stringField>a string</stringField>    <intField>42</intField>    <doubleArrayField>1.2, 4.5, -0.034</doubleArrayField>  </simple>  <annotatedPojo>    <targetBand>result</targetBand>    <targetBands>      <band>a</band>      <band>b</band>    </targetBands>  </annotatedPojo></parameters>";
        XppDom dom = this.createDom("<parameters>  <simple>    <stringField>a string</stringField>    <intField>42</intField>    <doubleArrayField>1.2, 4.5, -0.034</doubleArrayField>  </simple>  <annotatedPojo>    <targetBand>result</targetBand>    <targetBands>      <band>a</band>      <band>b</band>    </targetBands>  </annotatedPojo></parameters>");
        ComplexPojo value = new ComplexPojo();
        Assert.assertNull((Object)value.simplePojo);
        Assert.assertNull((Object)value.annotatedPojo);
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertEquals((long)42L, (long)value.simplePojo.intField);
        Assert.assertEquals((Object)"a string", (Object)value.simplePojo.stringField);
        Assert.assertNotNull((Object)value.simplePojo.doubleArrayField);
        Assert.assertEquals((long)3L, (long)value.simplePojo.doubleArrayField.length);
        Assert.assertEquals((double)1.2, (double)value.simplePojo.doubleArrayField[0], (double)1.0E-10);
        Assert.assertEquals((double)4.5, (double)value.simplePojo.doubleArrayField[1], (double)1.0E-10);
        Assert.assertEquals((double)-0.034, (double)value.simplePojo.doubleArrayField[2], (double)1.0E-10);
        Assert.assertEquals((Object)"result", (Object)value.annotatedPojo.targetBandName);
        Assert.assertEquals((Object)"reflec_13", (Object)value.annotatedPojo.defaultBandName);
        Assert.assertNotNull((Object)value.annotatedPojo.targetBandNames);
        Assert.assertEquals((long)2L, (long)value.annotatedPojo.targetBandNames.length);
        Assert.assertEquals((Object)"a", (Object)value.annotatedPojo.targetBandNames[0]);
        Assert.assertEquals((Object)"b", (Object)value.annotatedPojo.targetBandNames[1]);
    }

    @Test
    public void testComplexPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <simple>\n    <stringField>Test, test, test!</stringField>\n    <intField>87</intField>\n    <doubleArrayField>0.5,1.0</doubleArrayField>\n  </simple>\n  <annotatedPojo>\n    <targetBand>reflec_4</targetBand>\n    <defaultBandName>reflec_27</defaultBandName>\n    <targetBands>\n      <band>real</band>\n      <band>imag</band>\n    </targetBands>\n  </annotatedPojo>\n</parameters>";
        ComplexPojo value = new ComplexPojo();
        value.simplePojo = new SimplePojo();
        value.simplePojo.intField = 87;
        value.simplePojo.stringField = "Test, test, test!";
        value.simplePojo.doubleArrayField = new double[]{0.5, 1.0};
        value.annotatedPojo = new AnnotatedPojo();
        value.annotatedPojo.targetBandName = "reflec_4";
        value.annotatedPojo.defaultBandName = "reflec_27";
        value.annotatedPojo.targetBandNames = new String[]{"real", "imag"};
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <simple>\n    <stringField>Test, test, test!</stringField>\n    <intField>87</intField>\n    <doubleArrayField>0.5,1.0</doubleArrayField>\n  </simple>\n  <annotatedPojo>\n    <targetBand>reflec_4</targetBand>\n    <defaultBandName>reflec_27</defaultBandName>\n    <targetBands>\n      <band>real</band>\n      <band>imag</band>\n    </targetBands>\n  </annotatedPojo>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToNamedItemArrayPojo() throws Exception {
        String xml = "<parameters>  <endmembers>    <endmember>      <name>Land</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>220,230,240,250</radiances>    </endmember>    <endmember>      <name>Water</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>620,630,640,650</radiances>    </endmember>    <endmember>      <name>Cloud</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>920,930,940,950</radiances>    </endmember>  </endmembers>  <defaultEndmember>    <name>Fallback</name>    <size>4</size>    <wavelengths>820,830,840,850</wavelengths>    <radiances>420,430,440,450</radiances>  </defaultEndmember></parameters>";
        XppDom dom = this.createDom("<parameters>  <endmembers>    <endmember>      <name>Land</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>220,230,240,250</radiances>    </endmember>    <endmember>      <name>Water</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>620,630,640,650</radiances>    </endmember>    <endmember>      <name>Cloud</name>      <size>4</size>      <wavelengths>820,830,840,850</wavelengths>      <radiances>920,930,940,950</radiances>    </endmember>  </endmembers>  <defaultEndmember>    <name>Fallback</name>    <size>4</size>    <wavelengths>820,830,840,850</wavelengths>    <radiances>420,430,440,450</radiances>  </defaultEndmember></parameters>");
        NamedItemArrayPojo value = new NamedItemArrayPojo();
        Assert.assertNull((Object)value.defaultEndmember);
        Assert.assertNull((Object)value.endmembers);
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertNotNull((Object)value.defaultEndmember);
        Assert.assertEquals((Object)"Fallback", (Object)value.defaultEndmember.name);
        Assert.assertEquals((long)4L, (long)value.defaultEndmember.size);
        Assert.assertNotNull((Object)value.defaultEndmember.wavelengths);
        Assert.assertNotNull((Object)value.defaultEndmember.radiances);
        Assert.assertNotNull((Object)value.endmembers);
        Assert.assertEquals((long)3L, (long)value.endmembers.length);
        Assert.assertEquals((Object)"Land", (Object)value.endmembers[0].name);
        Assert.assertEquals((long)4L, (long)value.endmembers[0].size);
        Assert.assertNotNull((Object)value.endmembers[0].wavelengths);
        Assert.assertNotNull((Object)value.endmembers[0].radiances);
        Assert.assertEquals((Object)"Water", (Object)value.endmembers[1].name);
        Assert.assertEquals((long)4L, (long)value.endmembers[1].size);
        Assert.assertNotNull((Object)value.endmembers[1].wavelengths);
        Assert.assertNotNull((Object)value.endmembers[1].radiances);
        Assert.assertEquals((Object)"Cloud", (Object)value.endmembers[2].name);
        Assert.assertEquals((long)4L, (long)value.endmembers[2].size);
        Assert.assertNotNull((Object)value.endmembers[2].wavelengths);
        Assert.assertNotNull((Object)value.endmembers[2].radiances);
    }

    @Test
    public void testNamedItemArrayPojoToDom() throws ValidationException, ConversionException {
        String expectedXml = "<parameters>\n  <defaultEndmember>\n    <name>Fallback</name>\n    <size>4</size>\n    <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n    <radiances>420.0,430.0,440.0,450.0</radiances>\n  </defaultEndmember>\n  <endmembers>\n    <endmember>\n      <name>Land</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>220.0,230.0,240.0,250.0</radiances>\n    </endmember>\n    <endmember>\n      <name>Water</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>620.0,630.0,640.0,650.0</radiances>\n    </endmember>\n    <endmember>\n      <name>Cloud</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>920.0,930.0,940.0,950.0</radiances>\n    </endmember>\n  </endmembers>\n</parameters>";
        NamedItemArrayPojo value = new NamedItemArrayPojo();
        value.defaultEndmember = new Endmember("Fallback", new double[]{820.0, 830.0, 840.0, 850.0}, new double[]{420.0, 430.0, 440.0, 450.0});
        value.endmembers = new Endmember[3];
        value.endmembers[0] = new Endmember("Land", new double[]{820.0, 830.0, 840.0, 850.0}, new double[]{220.0, 230.0, 240.0, 250.0});
        value.endmembers[1] = new Endmember("Water", new double[]{820.0, 830.0, 840.0, 850.0}, new double[]{620.0, 630.0, 640.0, 650.0});
        value.endmembers[2] = new Endmember("Cloud", new double[]{820.0, 830.0, 840.0, 850.0}, new double[]{920.0, 930.0, 940.0, 950.0});
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(value, dom);
        Assert.assertEquals((Object)"<parameters>\n  <defaultEndmember>\n    <name>Fallback</name>\n    <size>4</size>\n    <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n    <radiances>420.0,430.0,440.0,450.0</radiances>\n  </defaultEndmember>\n  <endmembers>\n    <endmember>\n      <name>Land</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>220.0,230.0,240.0,250.0</radiances>\n    </endmember>\n    <endmember>\n      <name>Water</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>620.0,630.0,640.0,650.0</radiances>\n    </endmember>\n    <endmember>\n      <name>Cloud</name>\n      <size>4</size>\n      <wavelengths>820.0,830.0,840.0,850.0</wavelengths>\n      <radiances>920.0,930.0,940.0,950.0</radiances>\n    </endmember>\n  </endmembers>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testInterfaceFieldsPojoToDom() throws ConversionException {
        String expectedXml = "<parameters>\n  <shape1 class=\"java.awt.Rectangle\">\n    <x>10</x>\n    <y>10</y>\n    <width>20</width>\n    <height>25</height>\n  </shape1>\n  <shape2 class=\"java.awt.geom.Line2D$Float\">\n    <x1>0.0</x1>\n    <y1>10.3</y1>\n    <x2>15.7</x2>\n    <y2>34.6</y2>\n  </shape2>\n</parameters>";
        InterfaceFieldsPojo interfacePojo = new InterfaceFieldsPojo(new Rectangle(10, 10, 20, 25), new Line2D.Float(0.0f, 10.3f, 15.7f, 34.6f));
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(interfacePojo, dom);
        Assert.assertEquals((Object)"<parameters>\n  <shape1 class=\"java.awt.Rectangle\">\n    <x>10</x>\n    <y>10</y>\n    <width>20</width>\n    <height>25</height>\n  </shape1>\n  <shape2 class=\"java.awt.geom.Line2D$Float\">\n    <x1>0.0</x1>\n    <y1>10.3</y1>\n    <x2>15.7</x2>\n    <y2>34.6</y2>\n  </shape2>\n</parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    @Test
    public void testDomToInterfaceFieldsPojo() throws Exception {
        String xml = "<parameters>\n  <shape1 class=\"java.awt.Rectangle\">\n    <x>10</x>\n    <y>10</y>\n    <width>20</width>\n    <height>25</height>\n  </shape1>\n  <shape2 class=\"java.awt.geom.Line2D$Float\">\n    <x1>0.0</x1>\n    <y1>10.3</y1>\n    <x2>15.7</x2>\n    <y2>34.6</y2>\n  </shape2>\n</parameters>";
        XppDom dom = this.createDom("<parameters>\n  <shape1 class=\"java.awt.Rectangle\">\n    <x>10</x>\n    <y>10</y>\n    <width>20</width>\n    <height>25</height>\n  </shape1>\n  <shape2 class=\"java.awt.geom.Line2D$Float\">\n    <x1>0.0</x1>\n    <y1>10.3</y1>\n    <x2>15.7</x2>\n    <y2>34.6</y2>\n  </shape2>\n</parameters>");
        InterfaceFieldsPojo value = new InterfaceFieldsPojo(null, null);
        Assert.assertNull((Object)value.shape1);
        Assert.assertNull((Object)value.shape2);
        DefaultDomConverterTest.convertDomToValue(dom, value);
        Assert.assertNotNull((Object)value.shape1);
        Assert.assertNotNull((Object)(value.shape1 instanceof Rectangle));
        Rectangle shape1 = (Rectangle)value.shape1;
        Assert.assertEquals((long)10L, (long)shape1.x);
        Assert.assertEquals((long)10L, (long)shape1.x);
        Assert.assertEquals((long)20L, (long)shape1.width);
        Assert.assertEquals((long)25L, (long)shape1.height);
        Assert.assertNotNull((Object)value.shape2);
        Assert.assertNotNull((Object)(value.shape2 instanceof Line2D.Float));
        Line2D.Float shape2 = (Line2D.Float)value.shape2;
        Assert.assertEquals((double)0.0, (double)shape2.x1, (double)1.0E-5);
        Assert.assertEquals((double)10.3f, (double)shape2.y1, (double)1.0E-5);
        Assert.assertEquals((double)15.7f, (double)shape2.x2, (double)1.0E-5);
        Assert.assertEquals((double)34.6f, (double)shape2.y2, (double)1.0E-5);
    }

    public void doNotTestMapFieldPojoToDom() throws ConversionException {
        String expectedXml = "<parameters>  <map class=\"java.util.HashMap\" >    <entry>      <key class=\"java.lang.String\">Bibo</key>      <value class=\"java.awt.Rectangle\">        <x>10</x>        <y>10</y>        <width>20</width>        <height>25</height>      </value>    </entry>    <entry>      <key class=\"java.lang.Integer\">12345</key>      <value class=\"java.awt.Color\">12,40,123</value>    </entry>  </map></parameters>";
        HashMap<Object, Serializable> map = new HashMap<Object, Serializable>();
        map.put("Bibo", new Rectangle(10, 10, 20, 25));
        map.put(12345, new Color(12, 40, 123));
        MapFieldPojo mapFieldPojo = new MapFieldPojo(map);
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(mapFieldPojo, dom);
        Assert.assertEquals((Object)"<parameters>  <map class=\"java.util.HashMap\" >    <entry>      <key class=\"java.lang.String\">Bibo</key>      <value class=\"java.awt.Rectangle\">        <x>10</x>        <y>10</y>        <width>20</width>        <height>25</height>      </value>    </entry>    <entry>      <key class=\"java.lang.Integer\">12345</key>      <value class=\"java.awt.Color\">12,40,123</value>    </entry>  </map></parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    public void doNotTestDomToMapFieldPojo() throws Exception {
        String xml = "<parameters>  <map class=\"java.util.HashMap\" >    <entry>      <key class=\"java.lang.String\">Bibo</key>      <value class=\"java.awt.Rectangle\">        <x>10</x>        <y>10</y>        <width>20</width>        <height>25</height>      </value>    </entry>    <entry>      <key class=\"java.lang.Integer\">12345</key>      <value class=\"java.awt.Color\">12,40,123</value>    </entry>  </map></parameters>";
        XppDom dom = this.createDom("<parameters>  <map class=\"java.util.HashMap\" >    <entry>      <key class=\"java.lang.String\">Bibo</key>      <value class=\"java.awt.Rectangle\">        <x>10</x>        <y>10</y>        <width>20</width>        <height>25</height>      </value>    </entry>    <entry>      <key class=\"java.lang.Integer\">12345</key>      <value class=\"java.awt.Color\">12,40,123</value>    </entry>  </map></parameters>");
        MapFieldPojo mapFieldPojo = new MapFieldPojo(null);
        DefaultDomConverterTest.convertDomToValue(dom, mapFieldPojo);
        Map<?, ?> map = mapFieldPojo.map;
        Assert.assertTrue((boolean)(map instanceof HashMap));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    public void doNotTestCollectionFieldPojoToDom() throws ConversionException {
        String expectedXml = "<parameters>  <collection class=\"java.util.Stack\">    <item class=\"java.awt.Rectangle\">      <x>0</x>      <y>0</y>      <width>10</width>      <height>10</height>    </item>    <item class=\"java.awt.geom.Line2D$Double\">      <x1>0.0</x1>      <y1>0.0</y1>      <x2>10.0</x2>      <y2>10.0</y2>    </item>    <item class=\"java.awt.geom.Arc2D$Double\">      <type>1</type>      <x>0.0</x>      <y>0.0</y>      <width>10.0</width>      <height>10.0</height>      <start>2.0</start>      <extent>3.0</extent>    </item>  </collection></parameters>";
        Stack<Shape> stack = new Stack<Shape>();
        stack.add(new Rectangle(0, 0, 10, 10));
        stack.add(new Line2D.Double(0.0, 0.0, 10.0, 10.0));
        stack.add(new Arc2D.Double(0.0, 0.0, 10.0, 10.0, 2.0, 3.0, 1));
        CollectionFieldPojo collectionFieldPojo = new CollectionFieldPojo(stack);
        XppDom dom = new XppDom("parameters");
        DefaultDomConverterTest.convertValueToDom(collectionFieldPojo, dom);
        Assert.assertEquals((Object)"<parameters>  <collection class=\"java.util.Stack\">    <item class=\"java.awt.Rectangle\">      <x>0</x>      <y>0</y>      <width>10</width>      <height>10</height>    </item>    <item class=\"java.awt.geom.Line2D$Double\">      <x1>0.0</x1>      <y1>0.0</y1>      <x2>10.0</x2>      <y2>10.0</y2>    </item>    <item class=\"java.awt.geom.Arc2D$Double\">      <type>1</type>      <x>0.0</x>      <y>0.0</y>      <width>10.0</width>      <height>10.0</height>      <start>2.0</start>      <extent>3.0</extent>    </item>  </collection></parameters>", (Object)DefaultDomConverterTest.getXml(dom));
    }

    public void doNotTestDomToCollectionFieldPojo() throws Exception {
        String xml = "<parameters>  <collection class=\"java.util.Stack\">    <item class=\"java.awt.Rectangle\">      <x>0</x>      <y>0</y>      <width>10</width>      <height>10</height>    </item>    <item class=\"java.awt.geom.Line2D$Double\">      <x1>0.0</x1>      <y1>0.0</y1>      <x2>10.0</x2>      <y2>10.0</y2>    </item>    <item class=\"java.awt.geom.Arc2D$Double\">      <type>1</type>      <x>0.0</x>      <y>0.0</y>      <width>10.0</width>      <height>10.0</height>      <start>2.0</start>      <extent>3.0</extent>    </item>  </collection></parameters>";
        XppDom dom = this.createDom("<parameters>  <collection class=\"java.util.Stack\">    <item class=\"java.awt.Rectangle\">      <x>0</x>      <y>0</y>      <width>10</width>      <height>10</height>    </item>    <item class=\"java.awt.geom.Line2D$Double\">      <x1>0.0</x1>      <y1>0.0</y1>      <x2>10.0</x2>      <y2>10.0</y2>    </item>    <item class=\"java.awt.geom.Arc2D$Double\">      <type>1</type>      <x>0.0</x>      <y>0.0</y>      <width>10.0</width>      <height>10.0</height>      <start>2.0</start>      <extent>3.0</extent>    </item>  </collection></parameters>");
        CollectionFieldPojo collectionFieldPojo = new CollectionFieldPojo(null);
        DefaultDomConverterTest.convertDomToValue(dom, collectionFieldPojo);
        Assert.assertTrue((boolean)(collectionFieldPojo.collection instanceof Stack));
        Stack stack = (Stack)collectionFieldPojo.collection;
        Assert.assertEquals((long)3L, (long)stack.size());
        Assert.assertTrue((boolean)(stack.get(0) instanceof Rectangle));
        Assert.assertTrue((boolean)(stack.get(1) instanceof Line2D.Double));
        Assert.assertTrue((boolean)(stack.get(2) instanceof Arc2D.Double));
    }

    private XppDom createDom(String xml) {
        XppDomWriter domWriter = new XppDomWriter();
        new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(xml), (XmlPullParser)new MXParser()), (HierarchicalStreamWriter)domWriter);
        return domWriter.getConfiguration();
    }

    public static String getXml(XppDom dom) {
        XppDomElement domElement = new XppDomElement(dom);
        return domElement.toXml();
    }

    public static void convertValueToDom(Object value, XppDom parentElement) throws ConversionException {
        DefaultDomConverter domConverter = new DefaultDomConverter(value.getClass(), PROPERTY_DESCRIPTOR_FACTORY);
        XppDomElement domElement = new XppDomElement(parentElement);
        domConverter.convertValueToDom(value, (DomElement)domElement);
    }

    public static void convertDomToValue(XppDom parentElement, Object value) throws Exception {
        DefaultDomConverter domConverter = new DefaultDomConverter(value.getClass(), PROPERTY_DESCRIPTOR_FACTORY);
        XppDomElement domElement = new XppDomElement(parentElement);
        domConverter.convertDomToValue((DomElement)domElement, value);
    }

    public static class Endmember {
        String name;
        int size;
        double[] wavelengths;
        double[] radiances;

        public Endmember() {
        }

        public Endmember(String name, double[] wavelengths, double[] radiances) {
            this.name = name;
            this.size = wavelengths.length;
            this.wavelengths = wavelengths;
            this.radiances = radiances;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface X {
        public String alias() default "";

        public String itemAlias() default "";

        public String defaultValue() default "";

        public Class<? extends DomConverter> domConverter() default DomConverter.class;
    }

    public static class Weird {
        static final Weird staticFinalWeird = new Weird();
        static Weird staticWeird = new Weird();
    }

    public static class WeirdPojo {
        final Weird finalWeird = new Weird();
        Weird weird;
        String name;
        transient Date timeStamp = new Date();
    }

    public static class CollectionFieldPojo {
        Collection collection;

        public CollectionFieldPojo(Collection collection) {
            this.collection = collection;
        }
    }

    public static class MapFieldPojo {
        Map<?, ?> map;

        public MapFieldPojo(Map<?, ?> map) {
            this.map = map;
        }
    }

    public static class InterfaceFieldsPojo {
        Shape shape1;
        Shape shape2;

        public InterfaceFieldsPojo(Shape shape1, Shape shape2) {
            this.shape1 = shape1;
            this.shape2 = shape2;
        }
    }

    public static class NamedItemArrayPojo {
        Endmember defaultEndmember;
        @X(itemAlias="endmember")
        Endmember[] endmembers;
    }

    public static class EnumPojo {
        Muppet character;

        private static enum Muppet {
            KERMIT,
            ANIMAL,
            MISS_PIGGY;

        }
    }

    public static class Member {
        private String name;

        public Member(String name) {
            this.name = name;
        }
    }

    public static class ArrayPojo {
        Member prince;
        Member[] allies;
    }

    public static class ArrayWithDomConverterPojo {
        @X(domConverter=MemberDomConverter.class)
        Member[] allies;
    }

    public static class MemberDomConverter
    implements DomConverter {
        private final DefaultDomConverter memberConverter = new DefaultDomConverter(Member.class);

        public Class<?> getValueType() {
            return Member.class;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            DomElement[] children = (DomElement[])parentElement.getChildren("member");
            Member[] members = new Member[children.length];
            for (int i = 0; i < children.length; ++i) {
                members[i] = (Member)this.memberConverter.convertDomToValue(children[i], null);
            }
            return members;
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            Member[] members;
            for (Member member : members = (Member[])value) {
                DomElement aggregator = parentElement.createChild("member");
                this.memberConverter.convertValueToDom((Object)member, aggregator);
            }
        }
    }

    public static class ComplexPojo {
        @X(alias="simple")
        SimplePojo simplePojo;
        AnnotatedPojo annotatedPojo;
    }

    public static class AnnotatedPojo {
        @X(alias="targetBand")
        String targetBandName;
        @X(defaultValue="reflec_13")
        String defaultBandName;
        @X(alias="targetBands", itemAlias="band")
        String[] targetBandNames;
    }

    public static class SimplePojo {
        File fileField;
        String stringField;
        int intField;
        double[] doubleArrayField;
    }
}

