/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.StringConverter;

public class StringArrayConverterTest
extends AbstractConverterTest {
    private ArrayConverter converter;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        }
        return this.converter;
    }

    @Override
    public void testConverter() throws ConversionException {
        StringArrayConverterTest.assertEquals((String)",", (String)",");
        this.testValueType(String[].class);
        this.testParseSuccess(new String[]{"a", "b", "c"}, "a,b,c");
        this.testParseSuccess(new String[]{" a", "\tb", "c\n"}, " a,\tb,c\n");
        this.testParseSuccess(new String[]{"a,b", "c,d", "e,f"}, "a\\u002Cb,c\\u002Cd,e\\u002Cf");
        this.testFormatSuccess("a,b,c", new String[]{"a", "b", "c"});
        this.testFormatSuccess(" a,\tb,c\n", new String[]{" a", "\tb", "c\n"});
        this.testFormatSuccess("a\\u002Cb,c\\u002Cd,e\\u002Cf", new String[]{"a,b", "c,d", "e,f"});
        this.assertNullCorrectlyHandled();
    }
}

