/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.FloatConverter;

public class FloatConverterTest
extends AbstractConverterTest {
    private FloatConverter converter;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new FloatConverter();
        }
        return this.converter;
    }

    @Override
    public void testConverter() throws ConversionException {
        this.testValueType(Float.class);
        this.testParseSuccess(Float.valueOf(234.0f), "234");
        this.testParseSuccess(Float.valueOf(-45.789f), "-45.789");
        this.testParseSuccess(Float.valueOf(0.25f), "+0.25");
        this.testParseSuccess(null, "");
        this.testParseSuccess(Float.valueOf(Float.NaN), "NaN");
        this.testFormatSuccess("2353465.0", Float.valueOf(2353465.0f));
        this.testFormatSuccess("-6.0", Float.valueOf(-6.0f));
        this.testFormatSuccess("0.0789", Float.valueOf(0.0789f));
        this.testFormatSuccess("NaN", Float.valueOf(Float.NaN));
        this.assertNullCorrectlyHandled();
    }
}

