/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.EnumConverter;

public class EnumConverterTest
extends AbstractConverterTest {
    private EnumConverter<Tests> converter;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new EnumConverter(Tests.class);
        }
        return this.converter;
    }

    @Override
    public void testConverter() throws ConversionException {
        this.testValueType(Tests.class);
        this.testParseSuccess((Object)Tests.TEST1, "TEST1");
        this.testParseSuccess((Object)Tests.TEST2, "TEST2");
        this.testParseSuccess((Object)Tests.TEST3, "TEST3");
        this.testParseSuccess(null, "");
        this.testParseFailed("test1");
        this.testParseFailed("Test 2");
        this.testFormatSuccess("TEST1", (Object)Tests.TEST1);
        this.testFormatSuccess("TEST2", (Object)Tests.TEST2);
        this.testFormatSuccess("TEST3", (Object)Tests.TEST3);
        this.testFormatSuccess("", null);
        this.assertNullCorrectlyHandled();
    }

    public void testConverterForwardAndBackward() throws ConversionException {
        Converter converter = this.getConverter();
        EnumConverterTest.assertEquals((Object)((Object)Tests.TEST1), (Object)converter.parse(converter.format((Object)Tests.TEST1)));
        EnumConverterTest.assertEquals((Object)((Object)Tests.TEST2), (Object)converter.parse(converter.format((Object)Tests.TEST2)));
        EnumConverterTest.assertEquals((Object)((Object)Tests.TEST3), (Object)converter.parse(converter.format((Object)Tests.TEST3)));
    }

    private static enum Tests {
        TEST1,
        TEST2{

            public String toString() {
                return "Test 2";
            }
        }
        ,
        TEST3;

    }
}

