/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.ColorConverter;
import java.awt.Color;

public class ColorConverterTest
extends AbstractConverterTest {
    private ColorConverter converter;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new ColorConverter();
        }
        return this.converter;
    }

    @Override
    public void testConverter() throws ConversionException {
        this.testValueType(Color.class);
        this.testParseSuccess(new Color(17, 11, 67), "17,11,67");
        this.testParseSuccess(new Color(17, 11, 67, 127), "17, \t11, 67, 127");
        this.testParseSuccess(null, "");
        this.testFormatSuccess("17,11,67", new Color(17, 11, 67));
        this.testFormatSuccess("17,11,67,127", new Color(17, 11, 67, 127));
        this.testFormatSuccess("", null);
        this.assertNullCorrectlyHandled();
        try {
            this.converter.parse("17,11");
            ColorConverterTest.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.converter.parse("17,11,67,1024");
            ColorConverterTest.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

