/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.converters.AbstractConverterTest;
import com.bc.ceres.binding.converters.ClassConverter;
import java.awt.Color;
import java.util.Date;
import org.w3c.dom.Text;

public class ClassConverterTest
extends AbstractConverterTest {
    private ClassConverter converter;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new ClassConverter();
        }
        return this.converter;
    }

    @Override
    public void testConverter() throws ConversionException {
        this.testValueType(Class.class);
        this.testParseSuccess(Character.TYPE, "char");
        this.testParseSuccess(Boolean.TYPE, "boolean");
        this.testParseSuccess(Byte.TYPE, "byte");
        this.testParseSuccess(Short.TYPE, "short");
        this.testParseSuccess(Integer.TYPE, "int");
        this.testParseSuccess(Float.TYPE, "float");
        this.testParseSuccess(Double.TYPE, "double");
        this.testFormatSuccess("char", Character.TYPE);
        this.testFormatSuccess("boolean", Boolean.TYPE);
        this.testFormatSuccess("byte", Byte.TYPE);
        this.testFormatSuccess("short", Short.TYPE);
        this.testFormatSuccess("int", Integer.TYPE);
        this.testFormatSuccess("float", Float.TYPE);
        this.testFormatSuccess("double", Double.TYPE);
        this.testParseSuccess(Integer.class, "Integer");
        this.testParseSuccess(Float.class, "Float");
        this.testParseSuccess(String.class, "String");
        this.testFormatSuccess("Integer", Integer.class);
        this.testFormatSuccess("Float", Float.class);
        this.testFormatSuccess("String", String.class);
        this.testParseSuccess(String[].class, "String[]");
        this.testParseSuccess(String[].class, "java.lang.String[]");
        this.testParseSuccess(String[].class, "[Ljava.lang.String;");
        this.testParseSuccess(Float[].class, "Float[]");
        this.testParseSuccess(ValueSet[].class, "com.bc.ceres.binding.ValueSet[]");
        this.testFormatSuccess("String[]", String[].class);
        this.testFormatSuccess("Float[]", Float[].class);
        this.testFormatSuccess("com.bc.ceres.binding.ValueSet[]", ValueSet[].class);
        this.testParseSuccess(Color.class, "java.awt.Color");
        this.testParseSuccess(Date.class, "java.util.Date");
        this.testParseSuccess(Date.class, "Date");
        this.testParseSuccess(Text.class, "org.w3c.dom.Text");
        this.testParseSuccess(null, "");
        this.testFormatSuccess("java.awt.Color", Color.class);
        this.testFormatSuccess("Date", Date.class);
        this.testFormatSuccess("org.w3c.dom.Text", Text.class);
        this.testFormatSuccess("", null);
        this.testParseFailed("Int");
        this.testParseFailed("you.will.be.Assimilated");
        this.assertNullCorrectlyHandled();
    }
}

