/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.lang.reflect.Array;
import junit.framework.TestCase;

public abstract class AbstractConverterTest
extends TestCase {
    protected AbstractConverterTest() {
    }

    public abstract Converter getConverter();

    public abstract void testConverter() throws ConversionException;

    protected void testValueType(Class<?> expectedType) {
        AbstractConverterTest.assertEquals(expectedType, (Object)this.getConverter().getValueType());
    }

    protected void testParseSuccess(Object expectedValue, String text) throws ConversionException {
        if (expectedValue != null && expectedValue.getClass().isArray()) {
            Object actualValue = this.getConverter().parse(text);
            AbstractConverterTest.assertTrue((boolean)actualValue.getClass().isArray());
            int expectedLength = Array.getLength(expectedValue);
            int actualLength = Array.getLength(actualValue);
            AbstractConverterTest.assertEquals((int)expectedLength, (int)actualLength);
            for (int i = 0; i < expectedLength; ++i) {
                Object expectedElem = Array.get(expectedValue, i);
                Object actualElem = Array.get(actualValue, i);
                AbstractConverterTest.assertEquals((String)("index=" + i), (Object)expectedElem, (Object)actualElem);
            }
        } else {
            Object actualValue = this.getConverter().parse(text);
            if (expectedValue instanceof Float && actualValue instanceof Float) {
                float ev = ((Float)expectedValue).floatValue();
                float av = ((Float)actualValue).floatValue();
                if (Float.isNaN(ev)) {
                    AbstractConverterTest.assertTrue((String)"Float.NaN expected", (boolean)Float.isNaN(av));
                } else {
                    AbstractConverterTest.assertEquals((float)ev, (float)av, (float)1.0E-10f);
                }
            } else if (expectedValue instanceof Double && actualValue instanceof Double) {
                double ev = (Double)expectedValue;
                double av = (Double)actualValue;
                if (Double.isNaN(ev)) {
                    AbstractConverterTest.assertTrue((String)"Double.NaN expected", (boolean)Double.isNaN(av));
                } else {
                    AbstractConverterTest.assertEquals((double)ev, (double)av, (double)1.0E-10);
                }
            } else {
                AbstractConverterTest.assertEquals((Object)expectedValue, (Object)actualValue);
            }
        }
        if (expectedValue != null) {
            AbstractConverterTest.assertTrue((boolean)this.getConverter().getValueType().isAssignableFrom(expectedValue.getClass()));
        }
    }

    protected void testParseFailed(String text) {
        try {
            this.getConverter().parse(text);
            AbstractConverterTest.fail((String)("ConversionException expected: " + text + " should not be convertible"));
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    protected void testFormatSuccess(String expectedText, Object value) throws ConversionException {
        if (value != null) {
            AbstractConverterTest.assertTrue((boolean)this.getConverter().getValueType().isAssignableFrom(value.getClass()));
        }
        AbstractConverterTest.assertEquals((String)expectedText, (String)this.getConverter().format(value));
    }

    public void assertNullCorrectlyHandled() {
        try {
            this.getConverter().parse(null);
            AbstractConverterTest.fail((String)"NullPointerException expected");
        }
        catch (ConversionException e) {
            AbstractConverterTest.fail((String)"ConversionException not expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String text = this.getConverter().format(null);
        AbstractConverterTest.assertNotNull((Object)text);
    }
}

