/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.converters.AffineTransformConverter;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.BooleanConverter;
import com.bc.ceres.binding.converters.ByteConverter;
import com.bc.ceres.binding.converters.CharacterConverter;
import com.bc.ceres.binding.converters.ColorConverter;
import com.bc.ceres.binding.converters.DateFormatConverter;
import com.bc.ceres.binding.converters.DoubleConverter;
import com.bc.ceres.binding.converters.EnumConverter;
import com.bc.ceres.binding.converters.FileConverter;
import com.bc.ceres.binding.converters.FloatConverter;
import com.bc.ceres.binding.converters.FontConverter;
import com.bc.ceres.binding.converters.IntegerConverter;
import com.bc.ceres.binding.converters.IntervalConverter;
import com.bc.ceres.binding.converters.LongConverter;
import com.bc.ceres.binding.converters.PatternConverter;
import com.bc.ceres.binding.converters.ShortConverter;
import com.bc.ceres.binding.converters.StringConverter;
import com.bc.ceres.binding.converters.UrlConverter;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ConverterRegistry {
    private Map<Class<?>, Converter<?>> converters = new HashMap(33);

    private ConverterRegistry() {
        this.setConverter(Boolean.TYPE, new BooleanConverter());
        this.setConverter(Character.TYPE, new CharacterConverter());
        this.setConverter(Byte.TYPE, new ByteConverter());
        this.setConverter(Short.TYPE, new ShortConverter());
        this.setConverter(Integer.TYPE, new IntegerConverter());
        this.setConverter(Long.TYPE, new LongConverter());
        this.setConverter(Float.TYPE, new FloatConverter());
        this.setConverter(Double.TYPE, new DoubleConverter());
        this.setConverter(Boolean.class, new BooleanConverter());
        this.setConverter(Character.class, new CharacterConverter());
        this.setConverter(Byte.class, new ByteConverter());
        this.setConverter(Short.class, new ShortConverter());
        this.setConverter(Integer.class, new IntegerConverter());
        this.setConverter(Long.class, new LongConverter());
        this.setConverter(Float.class, new FloatConverter());
        this.setConverter(Double.class, new DoubleConverter());
        this.setConverter(AffineTransform.class, new AffineTransformConverter());
        this.setConverter(Color.class, new ColorConverter());
        this.setConverter(Date.class, new DateFormatConverter());
        this.setConverter(File.class, new FileConverter());
        this.setConverter(URL.class, new UrlConverter());
        this.setConverter(Font.class, new FontConverter());
        this.setConverter(Pattern.class, new PatternConverter());
        this.setConverter(String.class, new StringConverter());
        this.setConverter(ValueRange.class, new IntervalConverter());
    }

    public static ConverterRegistry getInstance() {
        return Holder.instance;
    }

    public <T> void setConverter(Class<? extends T> type, Converter<T> converter) {
        this.converters.put(type, converter);
    }

    public <T> Converter<T> getConverter(Class<? extends T> type) {
        Converter<?> converter = this.converters.get(type);
        if (converter == null) {
            for (Map.Entry<Class<?>, Converter<?>> entry : this.converters.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                converter = entry.getValue();
                break;
            }
            if (converter == null) {
                if (type.isArray()) {
                    converter = this.getConverter(type.getComponentType());
                    if (converter != null) {
                        return new ArrayConverter(type, converter);
                    }
                } else if (type.isEnum()) {
                    return new EnumConverter<T>(type);
                }
            }
        }
        return converter;
    }

    private static class Holder {
        private static final ConverterRegistry instance = new ConverterRegistry();

        private Holder() {
        }
    }
}

