/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class SnapshotSelectorModel {
    private final SpinnerListModel spinnerModel;
    private final BoundedRangeModel sliderModel;
    private final PlainDocument sliderInfoDocument;

    SnapshotSelectorModel(List<Long> snapshotIds) {
        this.spinnerModel = new SpinnerListModel(snapshotIds);
        this.sliderModel = new DefaultBoundedRangeModel(0, 0, 0, snapshotIds.size() - 1);
        this.sliderInfoDocument = new PlainDocument();
        this.spinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int sliderValue = Collections.binarySearch(SnapshotSelectorModel.this.getSpinnerModelList(), SnapshotSelectorModel.this.spinnerModel.getValue());
                SnapshotSelectorModel.this.sliderModel.setValue(sliderValue);
            }
        });
        this.sliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SnapshotSelectorModel.this.updateSliderInfoDocument();
                Object spinnerValue = SnapshotSelectorModel.this.getSpinnerModelList().get(SnapshotSelectorModel.this.sliderModel.getValue());
                SnapshotSelectorModel.this.spinnerModel.setValue(spinnerValue);
            }
        });
        this.updateSliderInfoDocument();
    }

    long getSnapshotId() {
        return (Long)this.spinnerModel.getValue();
    }

    void setSnapshotId(long id) {
        this.spinnerModel.setValue(id);
    }

    SpinnerModel getSpinnerModel() {
        return this.spinnerModel;
    }

    BoundedRangeModel getSliderModel() {
        return this.sliderModel;
    }

    Document getSliderInfoDocument() {
        return this.sliderInfoDocument;
    }

    private List<? extends Comparable<? super Object>> getSpinnerModelList() {
        return this.spinnerModel.getList();
    }

    private void updateSliderInfoDocument() {
        String text = SnapshotSelectorModel.createSliderInfoText(this.sliderModel);
        try {
            this.sliderInfoDocument.replace(0, this.sliderInfoDocument.getLength(), text, null);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static String createSliderInfoText(BoundedRangeModel sliderModel) {
        return MessageFormat.format("{0} / {1}", sliderModel.getValue() + 1, sliderModel.getMaximum() + 1);
    }
}

