/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.gui.swing.SnapshotSelectorModel;

public class SnapshotSelectorComboModel
implements ComboBoxModel {
    private final ComboBoxModel<String> comboBoxModel;
    private final Map<Object, SnapshotSelectorModel> map = new HashMap<Object, SnapshotSelectorModel>();

    public SnapshotSelectorComboModel(SnapshotInfo snapshotInfo) {
        this.map.put("Any", new SnapshotSelectorModel(snapshotInfo.getSnapshotIds()));
        this.map.put("X", new SnapshotSelectorModel(snapshotInfo.getSnapshotIdsX()));
        this.map.put("Y", new SnapshotSelectorModel(snapshotInfo.getSnapshotIdsY()));
        if (snapshotInfo.getSnapshotIdsXY().size() != 0) {
            this.map.put("XY", new SnapshotSelectorModel(snapshotInfo.getSnapshotIdsXY()));
            this.comboBoxModel = new DefaultComboBoxModel<String>(new String[]{"Any", "X", "Y", "XY"});
        } else {
            this.comboBoxModel = new DefaultComboBoxModel<String>(new String[]{"Any", "X", "Y"});
        }
    }

    SnapshotSelectorModel getSelectedModel() {
        return this.getModel(this.comboBoxModel.getSelectedItem());
    }

    SnapshotSelectorModel getModel(Object item) {
        return this.map.get(item);
    }

    @Override
    public void setSelectedItem(Object newItem) {
        Object oldItem = this.getSelectedItem();
        SnapshotSelectorModel oldModel = this.map.get(oldItem);
        SnapshotSelectorModel newModel = this.map.get(newItem);
        try {
            newModel.setSnapshotId(oldModel.getSnapshotId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.comboBoxModel.setSelectedItem(newItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.comboBoxModel.getSelectedItem();
    }

    @Override
    public int getSize() {
        return this.comboBoxModel.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        return this.comboBoxModel.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.comboBoxModel.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.comboBoxModel.removeListDataListener(l);
    }
}

