/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.esa.smos.gui.swing.SnapshotSelector;
import org.esa.smos.gui.swing.SnapshotSelectorComboModel;

public class SnapshotSelectorCombo {
    private final JComboBox comboBox = new SnapshotSelectorComboBox();
    private final SnapshotSelector snapshotSelector = new SnapshotSelector();
    private SnapshotSelectorComboModel model;

    public SnapshotSelectorCombo() {
        this.comboBox.setEditable(false);
    }

    SnapshotSelectorCombo(SnapshotSelectorComboModel model) {
        this();
        this.setModel(model);
    }

    JComboBox getComboBox() {
        return this.comboBox;
    }

    JSpinner getSpinner() {
        return this.snapshotSelector.getSpinner();
    }

    JSlider getSlider() {
        return this.snapshotSelector.getSlider();
    }

    JTextField getSliderInfo() {
        return this.snapshotSelector.getSliderInfo();
    }

    public void addSliderChangeListener(ChangeListener l) {
        this.getSlider().addChangeListener(l);
    }

    public boolean isAdjusting() {
        return this.getSlider().getValueIsAdjusting();
    }

    public long getSnapshotId() {
        return (Long)this.getSpinner().getValue();
    }

    public void setSnapshotId(long id) {
        this.getSpinner().setValue(id);
    }

    public final void setModel(SnapshotSelectorComboModel model) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (this.model != model) {
            this.model = model;
            this.comboBox.setModel(model);
            this.snapshotSelector.setModel(model.getSelectedModel());
        }
    }

    public void setComboBoxEnabled(boolean enabled) {
        this.getComboBox().setEnabled(enabled);
    }

    public void setComboBoxSelectedIndex(int index) {
        this.getComboBox().setSelectedIndex(index);
    }

    public void addComboBoxActionListener(ActionListener l) {
        this.getComboBox().addActionListener(l);
    }

    public static JComponent createComponent(SnapshotSelectorCombo combo, boolean showSliderInfo) {
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)new JLabel("ID: "), "West");
        westPanel.add((Component)combo.getSpinner(), "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)combo.getSlider(), "Center");
        if (showSliderInfo) {
            centerPanel.add((Component)combo.getSliderInfo(), "East");
        }
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.add((Component)new JLabel("Mode: "), "West");
        eastPanel.add((Component)combo.getComboBox(), "East");
        JPanel component = new JPanel(new BorderLayout(4, 4));
        component.add((Component)westPanel, "West");
        component.add((Component)centerPanel, "Center");
        component.add((Component)eastPanel, "East");
        return component;
    }

    private class SnapshotSelectorComboBox
    extends JComboBox {
        private SnapshotSelectorComboBox() {
        }

        @Override
        public void setSelectedItem(Object object) {
            if (SnapshotSelectorCombo.this.model != null) {
                SnapshotSelectorCombo.this.snapshotSelector.setModel(SnapshotSelectorCombo.this.model.getModel(object));
            }
            super.setSelectedItem(object);
        }
    }
}

