/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.esa.smos.gui.swing.SnapshotSelectorModel;

class SnapshotSelector {
    private final JSpinner spinner = new JSpinner();
    private final JSlider slider = new JSlider();
    private final JTextField sliderInfo;
    private SnapshotSelectorModel model;

    SnapshotSelector() {
        this.slider.setSnapToTicks(true);
        this.slider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int currentValue = SnapshotSelector.this.slider.getModel().getValue();
                SnapshotSelector.this.slider.getModel().setValue(currentValue + e.getWheelRotation());
            }
        });
        this.sliderInfo = new JTextField(10);
        this.sliderInfo.setEditable(false);
    }

    SnapshotSelector(SnapshotSelectorModel model) {
        this();
        this.setModel(model);
    }

    JSpinner getSpinner() {
        return this.spinner;
    }

    JSlider getSlider() {
        return this.slider;
    }

    JTextField getSliderInfo() {
        return this.sliderInfo;
    }

    final void setModel(SnapshotSelectorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (this.model != model) {
            this.model = model;
            this.spinner.setModel(model.getSpinnerModel());
            this.spinner.setEditor(new ListEditor(this.spinner));
            this.slider.setModel(model.getSliderModel());
            this.sliderInfo.setDocument(model.getSliderInfoDocument());
        }
    }

    private static class ListEditor
    extends JSpinner.ListEditor {
        public ListEditor(JSpinner spinner) {
            super(spinner);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JSpinner spinner = this.getSpinner();
            if (spinner == null) {
                return;
            }
            Object source = e.getSource();
            String name = e.getPropertyName();
            if (source instanceof JFormattedTextField && "value".equals(name)) {
                Object lastValue = spinner.getValue();
                try {
                    Object value = this.getTextField().getValue();
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        spinner.setValue(number.longValue());
                    } else {
                        spinner.setValue(Long.parseLong(value.toString()));
                    }
                }
                catch (IllegalArgumentException iae) {
                    try {
                        ((JFormattedTextField)source).setValue(lastValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

