/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.snapshot;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.FileMultiLevelSource;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.L1cScienceValueProvider;
import org.esa.smos.dataio.smos.SmosMultiLevelSource;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.bufr.LightBufrMultiLevelSource;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.ee2netcdf.reader.ScienceFlagsValueProvider;
import org.esa.smos.ee2netcdf.reader.ScienceValueProvider;
import org.esa.smos.gui.ProgressBarProgressMonitor;
import org.esa.smos.gui.SmosBox;
import org.esa.smos.gui.SmosTopComponent;
import org.esa.smos.gui.TableModelExportRunner;
import org.esa.smos.gui.snapshot.SnapshotTableModel;
import org.esa.smos.gui.swing.SnapshotSelectorCombo;
import org.esa.smos.gui.swing.SnapshotSelectorComboModel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.TiledFileMultiLevelSource;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.product.ProductSceneView;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.layout.CenterLayout;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SnapshotInfoTopComponent", iconBase="org/esa/smos/icons/SmosSnapshot.png", persistenceType=0)
public class SnapshotInfoTopComponent
extends SmosTopComponent {
    static final String DISPLAY_NAME = "SMOS L1C Snapshot";
    private static final SnapshotTableModel NULL_MODEL = new SnapshotTableModel(new Object[0][0]);
    private SnapshotSelectorCombo snapshotSelectorCombo;
    private JXTable snapshotTable;
    private ButtonModel locateSnapshotButtonModel;
    private ButtonModel browseButtonModel;
    private ButtonModel snapshotButtonModel;
    private ButtonModel followModeButtonModel;
    private ButtonModel synchronizeButtonModel;
    private SnapshotIdListener snapshotIdListener;

    public SnapshotInfoTopComponent() {
        this.setDisplayName(DISPLAY_NAME);
    }

    @Override
    protected JComponent createClientComponent() {
        this.snapshotIdListener = new SnapshotIdListener();
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.snapshotSelectorCombo = new SnapshotSelectorCombo();
        this.snapshotSelectorCombo.addSliderChangeListener(this.snapshotIdListener);
        this.snapshotSelectorCombo.addComboBoxActionListener(e -> this.updateTable(this.snapshotSelectorCombo.getSnapshotId()));
        JComponent comboComponent = SnapshotSelectorCombo.createComponent(this.snapshotSelectorCombo, false);
        mainPanel.add((Component)comboComponent, "North");
        JPanel snapshotTablePanel = this.createSnapshotTablePanel();
        mainPanel.add((Component)snapshotTablePanel, "Center");
        JPanel viewSettingsPanel = this.createViewSettingsPanel();
        JPanel southPanel = new JPanel(new BorderLayout(6, 0));
        southPanel.add((Component)viewSettingsPanel, "West");
        AbstractButton helpButton = this.createHelpButton();
        southPanel.add((Component)helpButton, "East");
        mainPanel.add((Component)southPanel, "South");
        return mainPanel;
    }

    @Override
    protected void updateClientComponent(ProductSceneView smosView) {
        SmosReader l1CScienceSmosReader = SmosBox.getL1CScienceSmosReader(smosView);
        if (l1CScienceSmosReader != null) {
            if (!l1CScienceSmosReader.hasSnapshotInfo()) {
                this.startPolModeInitWaiting(smosView, l1CScienceSmosReader);
                return;
            }
            if (l1CScienceSmosReader.getSnapshotInfo().containsData()) {
                long snapshotId = this.getSelectedSnapshotId(smosView.getRaster());
                this.updateUI(smosView, snapshotId, true);
            } else {
                super.realizeSmosView(null);
            }
        } else {
            super.realizeSmosView(null);
        }
    }

    private void updateTable(long snapshotId) {
        SnapshotInfo snapshotInfo;
        int snapshotIndex;
        final SmosReader smosReader = this.getSelectedSmosReader();
        if (smosReader != null && smosReader.canSupplySnapshotData() && (snapshotIndex = (snapshotInfo = smosReader.getSnapshotInfo()).getSnapshotIndex(snapshotId)) != -1) {
            SwingWorker<TableModel, Object> worker = new SwingWorker<TableModel, Object>(){

                @Override
                protected TableModel doInBackground() throws Exception {
                    Object[][] snapshotData = smosReader.getSnapshotData(snapshotIndex);
                    return new SnapshotTableModel(snapshotData);
                }

                @Override
                protected void done() {
                    try {
                        TableModel tableModel = (TableModel)this.get();
                        SnapshotInfoTopComponent.this.snapshotTable.setModel(tableModel);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        SnapshotInfoTopComponent.this.snapshotTable.setModel((TableModel)NULL_MODEL);
                    }
                }
            };
            worker.execute();
            return;
        }
        this.snapshotTable.setModel((TableModel)NULL_MODEL);
    }

    private void updateSnapshotImage(RasterDataNode raster, long snapshotId) {
        MultiLevelImage sourceImage = raster.getSourceImage();
        if (sourceImage instanceof DefaultMultiLevelImage) {
            LightBufrMultiLevelSource lightBufrMultiLevelSource;
            CellValueProvider valueProvider;
            DefaultMultiLevelImage multiLevelImage = (DefaultMultiLevelImage)sourceImage;
            MultiLevelSource source = multiLevelImage.getSource();
            if (source instanceof SmosMultiLevelSource) {
                ScienceFlagsValueProvider scienceFlagsValueProvider;
                SmosMultiLevelSource smosMultiLevelSource = (SmosMultiLevelSource)source;
                ValueProvider valueProvider2 = smosMultiLevelSource.getValueProvider();
                if (valueProvider2 instanceof L1cScienceValueProvider) {
                    L1cScienceValueProvider btDataValueProvider = (L1cScienceValueProvider)valueProvider2;
                    if (btDataValueProvider.getSnapshotId() != snapshotId) {
                        btDataValueProvider.setSnapshotId(snapshotId);
                    }
                } else if (valueProvider2 instanceof ScienceValueProvider) {
                    ScienceValueProvider scienceValueProvider = (ScienceValueProvider)valueProvider2;
                    if (scienceValueProvider.getSnapshotId() != snapshotId) {
                        scienceValueProvider.setSnapshotId(snapshotId);
                    }
                } else if (valueProvider2 instanceof ScienceFlagsValueProvider && (scienceFlagsValueProvider = (ScienceFlagsValueProvider)valueProvider2).getSnapshotId() != snapshotId) {
                    scienceFlagsValueProvider.setSnapshotId(snapshotId);
                }
            } else if (source instanceof LightBufrMultiLevelSource && (long)(valueProvider = (lightBufrMultiLevelSource = (LightBufrMultiLevelSource)source).getValueProvider()).getSnapshotId() != snapshotId) {
                valueProvider.setSnapshotId((int)snapshotId);
            }
            SnapshotInfoTopComponent.resetRasterImages(raster);
        }
    }

    private void locateSnapshotId(ProductSceneView smosView, long id) {
        SmosReader smosReader = SmosBox.getL1CScienceSmosReader(smosView);
        if (smosReader != null) {
            SnapshotInfo snapshotInfo = smosReader.getSnapshotInfo();
            Rectangle2D snapshotRegion = snapshotInfo.getArea(id).getBounds2D();
            if (snapshotRegion != null) {
                Viewport vp = smosView.getLayerCanvas().getViewport();
                AffineTransform m2v = vp.getModelToViewTransform();
                Point2D.Double center = new Point2D.Double(snapshotRegion.getCenterX(), snapshotRegion.getCenterY());
                m2v.transform(center, center);
                Rectangle viewBounds = vp.getViewBounds();
                double vx = viewBounds.getCenterX();
                double vy = viewBounds.getCenterY();
                vp.moveViewDelta(vx - center.getX(), vy - center.getY());
            } else {
                String message = MessageFormat.format("No snapshot found with ID = {0}", id);
                JOptionPane.showMessageDialog(this.getParent(), message);
            }
        }
    }

    static boolean isXPolarized(Band band) {
        return band.getName().endsWith("_X");
    }

    static boolean isYPolarized(Band band) {
        return band.getName().endsWith("_Y");
    }

    static boolean isXYPolarized(Band band) {
        return band.getName().contains("_XY");
    }

    private void updateAllImagesAndViews(Product smosProduct, long snapshotId) {
        long crossPolId;
        long yPolId;
        long xPolId;
        if (snapshotId != -1L) {
            Band[] smosReader = this.getSelectedSmosReader();
            SnapshotInfo snapshotInfo = smosReader.getSnapshotInfo();
            xPolId = SnapshotInfoTopComponent.findSnapshotId(snapshotInfo.getSnapshotIdsX(), snapshotId);
            yPolId = SnapshotInfoTopComponent.findSnapshotId(snapshotInfo.getSnapshotIdsY(), snapshotId);
            crossPolId = SnapshotInfoTopComponent.findSnapshotId(snapshotInfo.getSnapshotIdsXY(), snapshotId);
        } else {
            xPolId = -1L;
            yPolId = -1L;
            crossPolId = -1L;
        }
        for (Band band : smosProduct.getBands()) {
            if (band.getName().equals("Land_Sea_Mask")) continue;
            if (band instanceof VirtualBand) {
                SnapshotInfoTopComponent.resetRasterImages((RasterDataNode)band);
                continue;
            }
            if (SnapshotInfoTopComponent.isXPolarized(band)) {
                this.updateSnapshotImage((RasterDataNode)band, xPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isYPolarized(band)) {
                this.updateSnapshotImage((RasterDataNode)band, yPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isXYPolarized(band)) {
                this.updateSnapshotImage((RasterDataNode)band, crossPolId);
                continue;
            }
            if (band.isFlagBand()) {
                this.updateSnapshotImage((RasterDataNode)band, snapshotId);
                continue;
            }
            SnapshotInfoTopComponent.resetRasterImages((RasterDataNode)band);
        }
        for (Band band : smosProduct.getBands()) {
            if (band.getName().equals("Land_Sea_Mask")) continue;
            if (band instanceof VirtualBand) {
                this.updateViews((RasterDataNode)band, snapshotId);
                continue;
            }
            if (SnapshotInfoTopComponent.isXPolarized(band)) {
                this.updateViews((RasterDataNode)band, xPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isYPolarized(band)) {
                this.updateViews((RasterDataNode)band, yPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isXYPolarized(band)) {
                this.updateViews((RasterDataNode)band, crossPolId);
                continue;
            }
            this.updateViews((RasterDataNode)band, snapshotId);
        }
        for (Band band : smosProduct.getBands()) {
            if (band.getName().equals("Land_Sea_Mask")) continue;
            if (band instanceof VirtualBand) {
                this.setSelectedSnapshotId((RasterDataNode)band, snapshotId);
                continue;
            }
            if (SnapshotInfoTopComponent.isXPolarized(band)) {
                this.setSelectedSnapshotId((RasterDataNode)band, xPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isYPolarized(band)) {
                this.setSelectedSnapshotId((RasterDataNode)band, yPolId);
                continue;
            }
            if (SnapshotInfoTopComponent.isXYPolarized(band)) {
                this.setSelectedSnapshotId((RasterDataNode)band, crossPolId);
                continue;
            }
            this.setSelectedSnapshotId((RasterDataNode)band, snapshotId);
        }
        ProductNodeGroup maskGroup = smosProduct.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            mask.setSourceImage(null);
        }
    }

    private void updateViews(RasterDataNode raster, long snapshotId) {
        ProductSceneView view;
        ProductSceneViewTopComponent sceneViewTopComponent = this.getProductSceneViewTopComponent(raster);
        if (sceneViewTopComponent != null && this.getSelectedSnapshotId((view = sceneViewTopComponent.getView()).getRaster()) != snapshotId) {
            SnapshotInfoTopComponent.regenerateImageLayers(view.getRootLayer());
        }
    }

    private ProductSceneViewTopComponent getProductSceneViewTopComponent(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    private JPanel createViewSettingsPanel() {
        JCheckBox synchroniseCheckBox = new JCheckBox("Synchronise with view", false);
        this.synchronizeButtonModel = synchroniseCheckBox.getModel();
        this.synchronizeButtonModel.addActionListener(e -> {
            ProductSceneView smosView = this.getSelectedSmosView();
            long snapshotId = this.getSelectedSnapshotId(smosView);
            this.updateUI(smosView, snapshotId, false);
        });
        ToggleSnapshotModeAction toggleSnapshotModeAction = new ToggleSnapshotModeAction();
        JRadioButton browseButton = new JRadioButton("Browse", true);
        this.browseButtonModel = browseButton.getModel();
        this.browseButtonModel.addActionListener(toggleSnapshotModeAction);
        JRadioButton snapshotButton = new JRadioButton("Snapshot", false);
        this.snapshotButtonModel = snapshotButton.getModel();
        this.snapshotButtonModel.addActionListener(toggleSnapshotModeAction);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(browseButton);
        buttonGroup.add(snapshotButton);
        JCheckBox followModeCheckBox = new JCheckBox("Follow", false);
        this.followModeButtonModel = followModeCheckBox.getModel();
        JButton locateSnapshotButton = new JButton("Locate in view");
        locateSnapshotButton.addActionListener(new LocateSnapshotAction());
        locateSnapshotButton.setToolTipText("Locate selected snapshot in view");
        this.locateSnapshotButtonModel = locateSnapshotButton.getModel();
        JPanel viewSettingsPanel = new JPanel(new FlowLayout(3, 4, 4));
        viewSettingsPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        viewSettingsPanel.add(synchroniseCheckBox);
        viewSettingsPanel.add(browseButton);
        viewSettingsPanel.add(snapshotButton);
        viewSettingsPanel.add(followModeCheckBox);
        viewSettingsPanel.add(locateSnapshotButton);
        return viewSettingsPanel;
    }

    private void updateUI(ProductSceneView smosView, long snapshotId, boolean resetSelectorComboModel) {
        boolean sync;
        if (resetSelectorComboModel) {
            SmosReader smosReader = SmosBox.getL1CScienceSmosReader(smosView);
            this.snapshotSelectorCombo.setModel(new SnapshotSelectorComboModel(smosReader.getSnapshotInfo()));
        }
        if (sync = this.synchronizeButtonModel.isSelected()) {
            String bandName = smosView.getRaster().getName();
            if (bandName.endsWith("_X")) {
                this.snapshotSelectorCombo.setComboBoxSelectedIndex(1);
            } else if (bandName.endsWith("_Y")) {
                this.snapshotSelectorCombo.setComboBoxSelectedIndex(2);
            } else if (bandName.contains("_XY")) {
                this.snapshotSelectorCombo.setComboBoxSelectedIndex(3);
            } else {
                this.snapshotSelectorCombo.setComboBoxSelectedIndex(0);
            }
            if (snapshotId != -1L) {
                this.snapshotSelectorCombo.setSnapshotId(snapshotId);
                this.snapshotButtonModel.setSelected(true);
            } else {
                this.browseButtonModel.setSelected(true);
            }
        }
        this.updateTable(this.snapshotSelectorCombo.getSnapshotId());
        this.snapshotSelectorCombo.setComboBoxEnabled(!sync);
        this.browseButtonModel.setEnabled(sync);
        this.snapshotButtonModel.setEnabled(sync);
        this.followModeButtonModel.setEnabled(sync && this.snapshotButtonModel.isSelected());
        this.locateSnapshotButtonModel.setEnabled(sync && this.snapshotButtonModel.isSelected());
    }

    private JPanel createSnapshotTablePanel() {
        this.snapshotTable = new JXTable((TableModel)NULL_MODEL);
        this.snapshotTable.setAutoResizeMode(0);
        this.snapshotTable.setSortable(false);
        this.snapshotTable.setEditable(false);
        this.snapshotTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Number) {
                    this.setHorizontalAlignment(4);
                }
                return this;
            }
        });
        JPopupMenu tablePopup = new JPopupMenu();
        JMenuItem exportItem = new JMenuItem("Export...");
        Container parent = this.getParent();
        Window window = SwingUtilities.getWindowAncestor(parent);
        exportItem.addActionListener(e -> new TableModelExportRunner(window, this.getDisplayName(), this.snapshotTable.getModel(), (TableColumnModelExt)this.snapshotTable.getColumnModel()).run());
        tablePopup.add(exportItem);
        this.snapshotTable.add((Component)tablePopup);
        PopupListener popupListener = new PopupListener(tablePopup);
        this.snapshotTable.addMouseListener((MouseListener)popupListener);
        JPanel snapshotTablePanel = new JPanel(new BorderLayout());
        JLabel tableLabel = new JLabel("Snapshot Information:");
        tableLabel.setBorder(new EmptyBorder(4, 0, 0, 0));
        snapshotTablePanel.add((Component)tableLabel, "North");
        snapshotTablePanel.add((Component)new JScrollPane((Component)this.snapshotTable), "Center");
        return snapshotTablePanel;
    }

    private void startPolModeInitWaiting(ProductSceneView smosView, SmosReader l1CScienceSmosReader) {
        JPanel centerPanel = new JPanel((LayoutManager)new CenterLayout());
        centerPanel.setPreferredSize(new Dimension(300, 200));
        JPanel panel = new JPanel(new BorderLayout());
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JLabel message = new JLabel();
        panel.add((Component)message, "North");
        panel.add((Component)progressBar, "Center");
        centerPanel.add(panel);
        this.setToolViewComponent(centerPanel);
        ProgressBarProgressMonitor progressMonitor = new ProgressBarProgressMonitor(progressBar, message);
        PolModeWaiter worker = new PolModeWaiter(smosView, l1CScienceSmosReader, progressMonitor);
        progressMonitor.beginTask("Indexing snapshots and polarisation modes...", 100);
        worker.execute();
    }

    private static long findSnapshotId(List<Long> snapshotIds, long requestedId) {
        if (snapshotIds.size() == 0) {
            return -1L;
        }
        int foundIndex = Collections.binarySearch(snapshotIds, requestedId);
        if (foundIndex >= 0) {
            return snapshotIds.get(foundIndex);
        }
        int lowerIndex = -(foundIndex + 1) - 1;
        int upperIndex = -(foundIndex + 1);
        long lowerId = lowerIndex < 0 ? snapshotIds.get(0).longValue() : snapshotIds.get(lowerIndex).longValue();
        long upperId = upperIndex < snapshotIds.size() ? snapshotIds.get(upperIndex).longValue() : snapshotIds.get(snapshotIds.size() - 1).longValue();
        long foundId = requestedId - lowerId < upperId - requestedId ? lowerId : upperId;
        return foundId;
    }

    private static void regenerateImageLayers(Layer layer) {
        List children = layer.getChildren();
        int i = children.size();
        while (i-- > 0) {
            Layer child = (Layer)children.get(i);
            if (child instanceof ImageLayer) {
                ImageLayer imageLayer = (ImageLayer)child;
                if (imageLayer.getMultiLevelSource() instanceof FileMultiLevelSource || imageLayer.getMultiLevelSource() instanceof TiledFileMultiLevelSource) continue;
                imageLayer.regenerate();
                continue;
            }
            if (!(child instanceof CollectionLayer)) continue;
            SnapshotInfoTopComponent.regenerateImageLayers(child);
        }
    }

    private static void resetRasterImages(RasterDataNode raster) {
        raster.getSourceImage().reset();
        if (raster.isValidMaskImageSet()) {
            raster.resetValidMask();
            raster.getValidMaskImage().reset();
        }
        if (raster.isGeophysicalImageSet()) {
            raster.getGeophysicalImage().reset();
        }
        raster.setStx(null);
    }

    private static class PopupListener
    extends MouseAdapter {
        private final JPopupMenu popup;

        PopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class PolModeWaiter
    extends SwingWorker {
        private final ProductSceneView smosView;
        private final ProgressMonitor pm;
        private final SmosReader l1CScienceSmosReader;

        private PolModeWaiter(ProductSceneView smosView, SmosReader l1CScienceSmosReader, ProgressMonitor pm) {
            this.smosView = smosView;
            this.pm = pm;
            this.l1CScienceSmosReader = l1CScienceSmosReader;
        }

        protected Object doInBackground() throws InterruptedException {
            try {
                while (!this.l1CScienceSmosReader.hasSnapshotInfo()) {
                    Thread.sleep(100L);
                }
            }
            finally {
                this.pm.done();
            }
            return null;
        }

        @Override
        protected void done() {
            SnapshotInfo snapshotInfo = this.l1CScienceSmosReader.getSnapshotInfo();
            if (snapshotInfo.containsData()) {
                SnapshotInfoTopComponent.this.setToolViewComponent(SnapshotInfoTopComponent.this.getClientComponent());
            } else {
                SnapshotInfoTopComponent.this.setToolViewComponent(SnapshotInfoTopComponent.this.getDefaultComponent());
            }
            SnapshotInfoTopComponent.this.updateClientComponent(this.smosView);
        }
    }

    private class LocateSnapshotAction
    implements ActionListener {
        private LocateSnapshotAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ProductSceneView smosView = SnapshotInfoTopComponent.this.getSelectedSmosView();
            SnapshotInfoTopComponent.this.locateSnapshotId(smosView, SnapshotInfoTopComponent.this.getSelectedSnapshotId(smosView));
        }
    }

    private class ToggleSnapshotModeAction
    implements ActionListener {
        private ToggleSnapshotModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long snapshotId;
            ProductSceneView smosView = SnapshotInfoTopComponent.this.getSelectedSmosView();
            if (SnapshotInfoTopComponent.this.snapshotButtonModel.isSelected()) {
                snapshotId = SnapshotInfoTopComponent.this.snapshotSelectorCombo.getSnapshotId();
                if (SnapshotInfoTopComponent.this.followModeButtonModel.isSelected()) {
                    SnapshotInfoTopComponent.this.locateSnapshotId(smosView, snapshotId);
                }
            } else {
                snapshotId = -1L;
            }
            SnapshotInfoTopComponent.this.updateAllImagesAndViews(smosView.getProduct(), snapshotId);
            SnapshotInfoTopComponent.this.updateUI(smosView, snapshotId, false);
        }
    }

    private class SnapshotRegionOverlay
    implements LayerCanvas.Overlay {
        private long snapshotId;

        private SnapshotRegionOverlay() {
        }

        public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
            Rectangle2D snapshotRegion;
            ProductSceneView view = SnapshotInfoTopComponent.this.getSelectedSmosView();
            SmosReader smosReader = SmosBox.getL1CScienceSmosReader(view);
            if (smosReader != null && (snapshotRegion = smosReader.getSnapshotInfo().getArea(this.snapshotId).getBounds2D()) != null) {
                Graphics2D graphics = rendering.getGraphics();
                Viewport vp = view.getLayerCanvas().getViewport();
                AffineTransform m2v = vp.getModelToViewTransform();
                Shape transformedShape = m2v.createTransformedShape(snapshotRegion);
                Color color = graphics.getColor();
                graphics.setColor(Color.WHITE);
                graphics.draw(transformedShape);
                graphics.setColor(color);
            }
        }

        void setId(long snapshotId) {
            this.snapshotId = snapshotId;
        }
    }

    private class SnapshotIdListener
    implements ChangeListener {
        private SnapshotRegionOverlay overlay;
        private boolean overlayAdded;

        private SnapshotIdListener() {
            this.overlay = new SnapshotRegionOverlay();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ProductSceneView smosView;
            long snapshotId = SnapshotInfoTopComponent.this.snapshotSelectorCombo.getSnapshotId();
            SnapshotInfoTopComponent.this.updateTable(snapshotId);
            if (SnapshotInfoTopComponent.this.snapshotSelectorCombo.isAdjusting()) {
                if (SnapshotInfoTopComponent.this.snapshotButtonModel.isSelected()) {
                    this.overlay.setId(snapshotId);
                    if (!this.overlayAdded) {
                        this.overlayAdded = true;
                        SnapshotInfoTopComponent.this.getSelectedSmosView().getLayerCanvas().addOverlay((LayerCanvas.Overlay)this.overlay);
                    } else {
                        SnapshotInfoTopComponent.this.getSelectedSmosView().getLayerCanvas().repaint();
                    }
                }
                return;
            }
            SnapshotInfoTopComponent.this.getSelectedSmosView().getLayerCanvas().removeOverlay((LayerCanvas.Overlay)this.overlay);
            this.overlayAdded = false;
            if (SnapshotInfoTopComponent.this.synchronizeButtonModel.isSelected() && SnapshotInfoTopComponent.this.snapshotButtonModel.isSelected() && (smosView = SnapshotInfoTopComponent.this.getSelectedSmosView()) != null) {
                if (SnapshotInfoTopComponent.this.followModeButtonModel.isSelected()) {
                    SnapshotInfoTopComponent.this.locateSnapshotId(smosView, snapshotId);
                }
                SnapshotInfoTopComponent.this.updateAllImagesAndViews(smosView.getProduct(), snapshotId);
            }
        }
    }
}

