/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.gui.SceneViewSelectionService;
import org.esa.smos.gui.SmosBox;
import org.esa.smos.gui.SmosTopComponent;
import org.esa.smos.gui.gridpoint.GridPointSelectionService;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.HelpCtx;

public abstract class GridPointBtDataTopComponent
extends SmosTopComponent {
    private SmosBox smosBox;
    private JLabel infoLabel;
    private JCheckBox snapToSelectedPinCheckBox;
    private GPSL gpsl;

    @Override
    protected JComponent createClientComponent() {
        this.infoLabel = new JLabel();
        this.snapToSelectedPinCheckBox = new JCheckBox("Snap to selected pin");
        this.snapToSelectedPinCheckBox.addItemListener(new IL());
        JPanel optionsPanel = new JPanel(new BorderLayout(6, 0));
        optionsPanel.add((Component)this.snapToSelectedPinCheckBox, "West");
        optionsPanel.add((Component)this.createGridPointComponentOptionsComponent(), "Center");
        JPanel mainPanel = new JPanel(new BorderLayout(2, 2));
        mainPanel.add((Component)this.infoLabel, "Center");
        mainPanel.add((Component)this.createGridPointComponent(), "Center");
        mainPanel.add((Component)optionsPanel, "South");
        AbstractButton helpButton = this.createHelpButton();
        optionsPanel.add((Component)helpButton, "East");
        return mainPanel;
    }

    protected JComponent createGridPointComponentOptionsComponent() {
        return new JPanel();
    }

    boolean isSnappedToPin() {
        return this.snapToSelectedPinCheckBox.isSelected();
    }

    @Override
    public void componentOpened() {
        super.componentOpened();
        this.gpsl = new GPSL();
        this.smosBox = SmosBox.getInstance();
        GridPointSelectionService gpSelectionService = this.smosBox.getGridPointSelectionService();
        gpSelectionService.addGridPointSelectionListener(this.gpsl);
        this.updateGridPointBtDataComponent(gpSelectionService.getSelectedGridPointId());
    }

    @Override
    public void componentClosed() {
        super.componentClosed();
        this.smosBox.getGridPointSelectionService().removeGridPointSelectionListener(this.gpsl);
        this.updateGridPointBtDataComponent(-1);
    }

    final void updateGridPointBtDataComponent() {
        int id = -1;
        if (!this.isSnappedToPin()) {
            id = this.smosBox.getGridPointSelectionService().getSelectedGridPointId();
        } else {
            Placemark selectedPin;
            ProductSceneView view = this.getSelectedSmosView();
            if (view != null && (selectedPin = view.getSelectedPin()) != null) {
                PixelPos pixelPos = selectedPin.getPixelPos();
                int x = (int)Math.floor(pixelPos.getX());
                int y = (int)Math.floor(pixelPos.getY());
                id = this.smosBox.getSmosViewSelectionService().getGridPointId(x, y);
            }
        }
        this.updateGridPointBtDataComponent(id);
    }

    private void updateGridPointBtDataComponent(int selectedGridPointId) {
        if (selectedGridPointId == -1) {
            this.setInfoText("No data");
            this.clearGridPointBtDataComponent();
            return;
        }
        final SmosReader smosReader = this.getSelectedSmosReader();
        if (!smosReader.canSupplyGridPointBtData()) {
            this.setInfoText("No data");
            this.clearGridPointBtDataComponent();
            return;
        }
        final int gridPointIndex = smosReader.getGridPointIndex(selectedGridPointId);
        if (gridPointIndex >= 0) {
            this.setInfoText("<html>SEQNUM=<b>" + selectedGridPointId + "</b>, " + "INDEX=<b>" + gridPointIndex + "</b>" + "</html>");
            new SwingWorker<GridPointBtDataset, Void>(){

                @Override
                protected GridPointBtDataset doInBackground() throws ExecutionException {
                    try {
                        return smosReader.getBtData(gridPointIndex);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new ExecutionException(e);
                    }
                }

                @Override
                protected void done() {
                    try {
                        GridPointBtDataTopComponent.this.updateGridPointBtDataComponent((GridPointBtDataset)this.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        GridPointBtDataTopComponent.this.updateGridPointBtDataComponent(new IOException(e));
                    }
                }
            }.execute();
        } else {
            this.setInfoText("No data");
            this.clearGridPointBtDataComponent();
        }
    }

    protected void setInfoText(String text) {
        if (this.infoLabel != null) {
            this.infoLabel.setText(text);
        }
    }

    @Override
    public HelpCtx getHelpCtx() {
        return super.getHelpCtx();
    }

    protected abstract JComponent createGridPointComponent();

    protected abstract void updateGridPointBtDataComponent(GridPointBtDataset var1);

    protected abstract void updateGridPointBtDataComponent(IOException var1);

    protected abstract void clearGridPointBtDataComponent();

    private class IL
    implements ItemListener {
        private final PCL pcl = new PCL();
        private final PNL pnl = new PNL();
        private final VSL vsl = new VSL();

        private IL() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GridPointBtDataTopComponent.this.updateGridPointBtDataComponent();
                GridPointBtDataTopComponent.this.smosBox.getSmosViewSelectionService().addSceneViewSelectionListener(this.vsl);
                GridPointBtDataTopComponent.this.getSelectedSmosView().addPropertyChangeListener("selectedPin", (PropertyChangeListener)this.pcl);
                GridPointBtDataTopComponent.this.getSelectedSmosProduct().addProductNodeListener((ProductNodeListener)this.pnl);
            } else {
                GridPointBtDataTopComponent.this.getSelectedSmosProduct().removeProductNodeListener((ProductNodeListener)this.pnl);
                GridPointBtDataTopComponent.this.getSelectedSmosView().removePropertyChangeListener("selectedPin", (PropertyChangeListener)this.pcl);
                GridPointBtDataTopComponent.this.smosBox.getSmosViewSelectionService().removeSceneViewSelectionListener(this.vsl);
            }
        }

        private class VSL
        implements SceneViewSelectionService.SelectionListener {
            private VSL() {
            }

            @Override
            public void handleSceneViewSelectionChanged(ProductSceneView oldView, ProductSceneView newView) {
                if (oldView != null) {
                    oldView.removePropertyChangeListener("selectedPin", (PropertyChangeListener)IL.this.pcl);
                }
                if (newView != null) {
                    newView.addPropertyChangeListener("selectedPin", (PropertyChangeListener)IL.this.pcl);
                }
                GridPointBtDataTopComponent.this.updateGridPointBtDataComponent();
            }
        }

        private class PNL
        implements ProductNodeListener {
            private PNL() {
            }

            public void nodeChanged(ProductNodeEvent event) {
                this.updatePin(event);
            }

            public void nodeDataChanged(ProductNodeEvent event) {
                this.updatePin(event);
            }

            public void nodeAdded(ProductNodeEvent event) {
                this.updatePin(event);
            }

            public void nodeRemoved(ProductNodeEvent event) {
                this.updatePin(event);
            }

            private void updatePin(ProductNodeEvent event) {
                ProductNode sourceNode = event.getSourceNode();
                if (sourceNode instanceof Placemark) {
                    GridPointBtDataTopComponent.this.updateGridPointBtDataComponent();
                }
            }
        }

        private class PCL
        implements PropertyChangeListener {
            private PCL() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GridPointBtDataTopComponent.this.updateGridPointBtDataComponent();
            }
        }
    }

    private class GPSL
    implements GridPointSelectionService.SelectionListener {
        private GPSL() {
        }

        @Override
        public void handleGridPointSelectionChanged(int oldId, int newId) {
            if (!GridPointBtDataTopComponent.this.isSnappedToPin()) {
                GridPointBtDataTopComponent.this.updateGridPointBtDataComponent(newId);
            }
        }
    }
}

