/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.gui.TableModelExportRunner;
import org.esa.smos.gui.gridpoint.ColumnProperty;
import org.esa.smos.gui.gridpoint.GridPointBtDataTableModel;
import org.esa.smos.gui.gridpoint.GridPointBtDataTopComponent;
import org.esa.smos.gui.gridpoint.GridPointTableSelectionDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GridPointBtDataTableTopComponent", iconBase="org/esa/smos/icons/SmosGridPoint.png", persistenceType=0)
public class GridPointBtDataTableTopComponent
extends GridPointBtDataTopComponent {
    static final String DISPLAY_NAME = "SMOS L1C Table";
    private JXTable table;
    private JButton columnsButton;
    private JButton exportButton;
    private GridPointBtDataTableModel gridPointBtDataTableModel = new GridPointBtDataTableModel();

    public GridPointBtDataTableTopComponent() {
        this.table = new JXTable((TableModel)this.gridPointBtDataTableModel);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.setEditable(false);
        this.setDisplayName(DISPLAY_NAME);
    }

    @Override
    protected void updateClientComponent(ProductSceneView smosView) {
        boolean enabled = smosView != null;
        SmosReader smosReader = null;
        if (enabled && (smosReader = this.getSelectedSmosReader()) == null) {
            enabled = false;
        }
        this.table.setEnabled(enabled);
        this.columnsButton.setEnabled(enabled);
        this.exportButton.setEnabled(enabled);
        if (enabled) {
            String[] names = smosReader.getRawDataTableNames();
            this.gridPointBtDataTableModel.setColumnNames(names);
            DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
            this.table.setColumnModel((TableColumnModel)columnModel);
            this.table.createDefaultColumnsFromModel();
        }
    }

    @Override
    protected JComponent createGridPointComponent() {
        return new JScrollPane((Component)this.table);
    }

    @Override
    protected JComponent createGridPointComponentOptionsComponent() {
        this.columnsButton = new JButton("Select Columns ...");
        this.columnsButton.addActionListener(new SelectColumnActionListener());
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(e -> new TableModelExportRunner(this.getParent(), this.getShortName(), this.table.getModel(), (TableColumnModelExt)this.table.getColumnModel()).run());
        JPanel optionsPanel = new JPanel(new FlowLayout(2, 2, 2));
        optionsPanel.add(this.columnsButton);
        optionsPanel.add(this.exportButton);
        return optionsPanel;
    }

    @Override
    protected void updateGridPointBtDataComponent(GridPointBtDataset ds) {
        this.gridPointBtDataTableModel.setGridPointBtDataset(ds);
    }

    @Override
    protected void updateGridPointBtDataComponent(IOException e) {
        this.gridPointBtDataTableModel.setGridPointBtDataset(null);
    }

    @Override
    protected void clearGridPointBtDataComponent() {
        this.gridPointBtDataTableModel.setGridPointBtDataset(null);
    }

    private void updateVisibility(HashMap<String, Boolean> columnVisibilityMap) {
        Set<Map.Entry<String, Boolean>> entries = columnVisibilityMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entries) {
            TableColumnExt columnExt = this.table.getColumnExt((Object)entry.getKey());
            columnExt.setVisible(entry.getValue().booleanValue());
        }
        this.table.updateUI();
    }

    private class SelectColumnActionListener
    implements ActionListener {
        private SelectColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame rootJFrame = UIUtils.getRootJFrame((Component)((Object)GridPointBtDataTableTopComponent.this));
            String[] columnNames = GridPointBtDataTableTopComponent.this.gridPointBtDataTableModel.getColumnNames();
            ColumnProperty[] columnProperties = new ColumnProperty[columnNames.length];
            int index = 0;
            for (String columnName : columnNames) {
                TableColumnExt columnExt = GridPointBtDataTableTopComponent.this.table.getColumnExt((Object)columnName);
                columnProperties[index] = columnExt == null ? new ColumnProperty(columnName, false) : new ColumnProperty(columnName, columnExt.isVisible());
                ++index;
            }
            GridPointTableSelectionDialog dialog = GridPointTableSelectionDialog.create(rootJFrame, columnProperties);
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            GridPointBtDataTableTopComponent.this.updateVisibility(dialog.getSelection());
        }
    }
}

