/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.gui.export.GridPointFilter;
import org.esa.smos.gui.export.GridPointFilterStream;

public class SmosFileProcessor {
    private final GridPointFilterStream filterStream;
    private final GridPointFilter gridPointFilter;

    public SmosFileProcessor(GridPointFilterStream filterStream, GridPointFilter gridPointFilter) {
        this.filterStream = filterStream;
        this.gridPointFilter = gridPointFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SmosFile smosFile, ProgressMonitor pm) throws IOException {
        CompoundType gridPointType = smosFile.getGridPointType();
        int idIndex = gridPointType.getMemberIndex("Grid_Point_ID");
        this.filterStream.startFile(smosFile);
        int gridPointCount = smosFile.getGridPointCount();
        pm.beginTask(MessageFormat.format("Processing file ''{0}''...", smosFile.getDataFile().getName()), gridPointCount);
        try {
            for (int i = 0; i < gridPointCount; ++i) {
                CompoundData gridPointData = smosFile.getGridPointData(i);
                int id = gridPointData.getInt(idIndex);
                if (this.gridPointFilter.accept(id, gridPointData)) {
                    this.filterStream.handleGridPoint(i, gridPointData);
                }
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new IOException("Processing was cancelled by the user.");
            }
        }
        finally {
            this.filterStream.stopFile(smosFile);
            pm.done();
        }
    }
}

