/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.esa.smos.dataio.smos.ProductFile;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.SmosProductReader;
import org.esa.smos.gui.export.GridPointFilter;
import org.esa.smos.gui.export.GridPointFilterStream;
import org.esa.smos.gui.export.SmosFileProcessor;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;

class GridPointFilterStreamHandler {
    private final SmosFileProcessor smosFileProcessor;
    private static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.canRead();
        }
    };
    private static final FilenameFilter EEF_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(dir.getName() + ".HDR") || name.equals(dir.getName() + ".DBL");
        }
    };

    GridPointFilterStreamHandler(GridPointFilterStream filterStream, GridPointFilter gridPointFilter) {
        this.smosFileProcessor = new SmosFileProcessor(filterStream, gridPointFilter);
    }

    void processProduct(Product product, ProgressMonitor pm) throws IOException {
        SmosProductReader smosProductReader;
        ProductFile productFile;
        ProductReader productReader = product.getProductReader();
        if (productReader instanceof SmosProductReader && (productFile = (smosProductReader = (SmosProductReader)productReader).getProductFile()) instanceof SmosFile) {
            this.smosFileProcessor.process((SmosFile)productFile, pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDirectory(File dir, boolean recursive, ProgressMonitor pm, List<Exception> problemList) throws CanceledException {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        GridPointFilterStreamHandler.findSourceFiles(dir, recursive, sourceFileList);
        pm.beginTask("Exporting grid point data...", sourceFileList.size());
        try {
            for (File sourceFile : sourceFileList) {
                ProductFile productFile = null;
                try {
                    try {
                        productFile = SmosProductReader.createProductFile((File)sourceFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (productFile instanceof SmosFile) {
                        pm.setSubTaskName(MessageFormat.format("Processing file ''{0}''...", productFile.getDataFile().getName()));
                        try {
                            this.smosFileProcessor.process((SmosFile)productFile, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                        }
                        catch (Exception e) {
                            problemList.add(e);
                        }
                    } else {
                        pm.worked(1);
                    }
                    if (!pm.isCanceled()) continue;
                    throw new CanceledException();
                }
                finally {
                    if (productFile == null) continue;
                    try {
                        productFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private static void findSourceFiles(File parent, boolean recursive, List<File> sourceFileList) {
        File[] dirs = parent.listFiles(DIRECTORY_FILTER);
        if (dirs != null) {
            if (dirs.length == 0) {
                File[] files = parent.listFiles(EEF_FILENAME_FILTER);
                if (files != null && files.length == 2) {
                    if (files[0].getName().endsWith(".DBL")) {
                        sourceFileList.add(files[0]);
                    } else {
                        sourceFileList.add(files[1]);
                    }
                }
                return;
            }
            for (File dir : dirs) {
                File[] files = dir.listFiles(EEF_FILENAME_FILTER);
                if (files != null && files.length == 2) {
                    if (files[0].getName().endsWith(".DBL")) {
                        sourceFileList.add(files[0]);
                        continue;
                    }
                    sourceFileList.add(files[1]);
                    continue;
                }
                if (!recursive) continue;
                GridPointFilterStreamHandler.findSourceFiles(dir, recursive, sourceFileList);
            }
        }
    }
}

