/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.smos.gui.export.CsvExportStream;
import org.esa.smos.gui.export.EEExportStream;
import org.esa.smos.gui.export.ErrorHandler;
import org.esa.smos.gui.export.GPEArguments;
import org.esa.smos.gui.export.GridPointFilterStream;
import org.esa.smos.gui.export.GridPointFilterStreamHandler;
import org.esa.smos.gui.export.RegionFilter;

public class GridPointExporter {
    private static Logger logger;

    public static void main(String[] args) throws IOException {
        GridPointExporter.initializeLogging();
        GPEArguments arguments = new GPEArguments(args, new ErrorHandler(){

            @Override
            public void warning(Throwable t) {
            }

            @Override
            public void error(Throwable t) {
                System.err.println(t.getMessage());
                GridPointExporter.printUsageTo(System.out);
                System.exit(1);
            }
        });
        GridPointExporter.execute(arguments, new ErrorHandler(){

            @Override
            public void warning(Throwable t) {
                logger.warning(t.getMessage());
            }

            @Override
            public void error(Throwable t) {
                StackTraceElement[] stackTraceElements;
                System.err.println(t.getMessage());
                logger.severe(t.getMessage());
                for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
                    logger.severe(stackTraceElement.toString());
                }
                System.exit(1);
            }
        });
    }

    private static void initializeLogging() throws IOException {
        logger = Logger.getLogger("org.esa.smos");
        FileHandler fileHandler = new FileHandler("export.log");
        fileHandler.setLevel(Level.ALL);
        logger.addHandler(fileHandler);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.INFO);
        logger.addHandler(consoleHandler);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(GPEArguments arguments, ErrorHandler errorHandler) {
        ArrayList<Exception> problemList = new ArrayList<Exception>();
        logger.info(MessageFormat.format("targetFile = {0}", arguments.targetFile));
        Shape roi = arguments.getRoi();
        logger.info(MessageFormat.format("ROI = {0}", roi.getBounds2D()));
        GridPointFilterStream filterStream = null;
        try {
            filterStream = GridPointExporter.createGridPointFilterStream(arguments);
            GridPointFilterStreamHandler streamHandler = new GridPointFilterStreamHandler(filterStream, new RegionFilter(roi));
            for (File sourceFile : arguments.sourceFiles) {
                try {
                    logger.info(MessageFormat.format("Exporting source file ''{0}''.", sourceFile.getPath()));
                    streamHandler.processDirectory(sourceFile, false, ProgressMonitor.NULL, problemList);
                }
                catch (Exception e) {
                    errorHandler.warning(e);
                }
            }
        }
        catch (Exception e) {
            errorHandler.error(e);
        }
        finally {
            if (!problemList.isEmpty()) {
                for (Exception problem : problemList) {
                    errorHandler.warning(problem);
                }
            }
            if (filterStream != null) {
                try {
                    filterStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static GridPointFilterStream createGridPointFilterStream(GPEArguments arguments) throws IOException {
        if (arguments.targetFile != null) {
            if (arguments.targetFile.isDirectory()) {
                return new EEExportStream(arguments.targetFile);
            }
            return new CsvExportStream(new PrintWriter(arguments.targetFile), ";");
        }
        return new CsvExportStream(new PrintWriter(System.out), ";");
    }

    static void printUsageTo(PrintStream outputStream) {
        outputStream.println("SMOS-Box Grid Point Export command line tool, version 3.0");
        outputStream.println();
        outputStream.println("usage : export-grid-points [ROI] [-o targetFile] [sourceProduct ...]");
        outputStream.println();
        outputStream.println("ROI");
        outputStream.println("    [-box minLon maxLon minLat maxLat] | [-point lon lat]");
        outputStream.println("    a region-of-interest either defined by a latitude-longitude box");
        outputStream.println("    or the coordinates of a DGG grid point");
        outputStream.println();
        outputStream.println("Note that each source product must be specified by the path name of");
        outputStream.println("the directory which contains the SMOS '.HDR' and '.DBL' files.");
        outputStream.println();
        outputStream.println("targetFile");
        outputStream.println("    If the target file is a directory, the grid point data are exported");
        outputStream.println("      into that directory, the data is stored in EE formatted files.");
        outputStream.println("    If the target file is a normal file, the grid point data are stored");
        outputStream.println("      to this file as CSV table.");
        outputStream.println("    If no target file is specified, the grid point data are printed to");
        outputStream.println("      the console (in CSV format).");
    }
}

