/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.esa.smos.gui.export.CsvExportStream;
import org.esa.smos.gui.export.EEExportStream;
import org.esa.smos.gui.export.GridPointExportParameter;
import org.esa.smos.gui.export.GridPointFilter;
import org.esa.smos.gui.export.GridPointFilterStream;
import org.esa.smos.gui.export.GridPointFilterStreamHandler;
import org.esa.smos.gui.export.MultiFilter;
import org.esa.smos.gui.export.RegionFilter;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.ui.AppContext;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

class GridPointExportSwingWorker
extends ProgressMonitorSwingWorker<List<Exception>, File> {
    private final AppContext appContext;
    private final GridPointExportParameter gridPointExportParameter;

    GridPointExportSwingWorker(AppContext appContext, GridPointExportParameter gridPointExportParameter) {
        super((Component)appContext.getApplicationWindow(), "Exporting grid points");
        this.appContext = appContext;
        this.gridPointExportParameter = gridPointExportParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Exception> doInBackground(ProgressMonitor pm) throws Exception {
        ArrayList<Exception> problemList = new ArrayList<Exception>();
        try (GridPointFilterStream filterStream = null;){
            File targetFile = this.gridPointExportParameter.getTargetFile();
            String exportFormat = this.gridPointExportParameter.getExportFormat();
            filterStream = "CSV".equals(exportFormat) ? new CsvExportStream(new PrintWriter(targetFile), ";") : new EEExportStream(targetFile);
            GridPointFilter gridPointFilter = this.getGridPointFilter();
            GridPointFilterStreamHandler handler = new GridPointFilterStreamHandler(filterStream, gridPointFilter);
            if (this.gridPointExportParameter.isUseSelectedProduct()) {
                Product selectedProduct = this.appContext.getSelectedProduct();
                handler.processProduct(selectedProduct, pm);
            } else {
                File sourceDirectory = this.gridPointExportParameter.getSourceDirectory();
                boolean recursive = this.gridPointExportParameter.isRecursive();
                handler.processDirectory(sourceDirectory, recursive, pm, problemList);
            }
        }
        return problemList;
    }

    protected void done() {
        try {
            List problemList = (List)this.get();
            if (!problemList.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("The following problem(s) have occurred:\n");
                for (Exception problem : problemList) {
                    problem.printStackTrace();
                    message.append("  ");
                    message.append(problem.getMessage());
                    message.append("\n");
                }
                this.appContext.handleError(message.toString(), null);
            }
        }
        catch (InterruptedException e) {
            this.appContext.handleError(MessageFormat.format("An error occurred: {0}", e.getMessage()), (Throwable)e);
        }
        catch (ExecutionException e) {
            this.appContext.handleError(MessageFormat.format("An error occurred: {0}", e.getCause().getMessage()), e.getCause());
        }
    }

    private GridPointFilter getGridPointFilter() {
        int roiType = this.gridPointExportParameter.getRoiType();
        switch (roiType) {
            case 0: {
                MultiFilter multiFilter = new MultiFilter();
                VectorDataNode geometry = this.gridPointExportParameter.getGeometryNode();
                if (geometry != null) {
                    FeatureIterator featureIterator = geometry.getFeatureCollection().features();
                    while (featureIterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)featureIterator.next();
                        Shape featureShape = feature.getDefaultGeometry() instanceof Point ? this.getPointShape(feature) : this.getAreaShape(feature);
                        if (featureShape == null) continue;
                        multiFilter.add(new RegionFilter(featureShape));
                    }
                }
                return multiFilter;
            }
            case 1: {
                MultiFilter multiFilter = new MultiFilter();
                Product selectedProduct = this.appContext.getSelectedProduct();
                if (selectedProduct != null) {
                    PlacemarkGroup pinGroup = selectedProduct.getPinGroup();
                    for (Placemark pin : (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()])) {
                        multiFilter.add(new RegionFilter(this.getPointShape(pin.getFeature())));
                    }
                }
                return multiFilter;
            }
            case 2: {
                double north = this.gridPointExportParameter.getNorth();
                double south = this.gridPointExportParameter.getSouth();
                double east = this.gridPointExportParameter.getEast();
                double west = this.gridPointExportParameter.getWest();
                return new RegionFilter(new Rectangle2D.Double(west, south, east - west, north - south));
            }
        }
        throw new IllegalStateException(MessageFormat.format("Illegal ROI type: {0}", roiType));
    }

    private Shape getAreaShape(SimpleFeature feature) {
        try {
            Object geometry = feature.getDefaultGeometry();
            if (geometry instanceof Geometry) {
                return new LiteShape2((Geometry)geometry, null, null, true);
            }
        }
        catch (FactoryException | TransformException throwable) {
            // empty catch block
        }
        return null;
    }

    private Shape getPointShape(SimpleFeature feature) {
        Point point = (Point)feature.getDefaultGeometry();
        double lon = point.getX();
        double lat = point.getY();
        return new Rectangle2D.Double(lon, lat, 0.0, 0.0);
    }
}

