/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class GeometryTracker {
    private Rectangle2D.Double area = null;
    private Point2D.Double firstPoint = null;

    GeometryTracker() {
    }

    Rectangle2D getArea() {
        if (this.area == null) {
            return new Rectangle2D.Double();
        }
        return this.area.getBounds2D();
    }

    boolean hasValidArea() {
        return this.area != null && !this.area.isEmpty();
    }

    void add(Point2D.Double point) {
        if (this.area == null && this.firstPoint != null) {
            double minX = Math.min(this.firstPoint.getX(), point.getX());
            double maxX = Math.max(this.firstPoint.getX(), point.getX());
            double minY = Math.min(this.firstPoint.getY(), point.getY());
            double maxY = Math.max(this.firstPoint.getY(), point.getY());
            this.area = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        } else if (this.firstPoint == null) {
            this.firstPoint = point;
        } else {
            this.area.add(point);
        }
    }
}

