/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.text.DecimalFormat;
import java.util.Date;
import org.esa.smos.DateTimeUtils;

class FileNamePatcher {
    private String newStartDate;
    private String oldStartDate;
    private String newStopDate;
    private String oldStopDate;
    private String prefix;
    private String version;
    private String oldCounter;
    private String suffix;
    private int fileCounter;

    FileNamePatcher(String originalName) {
        this.prefix = originalName.substring(0, 19);
        this.oldStartDate = originalName.substring(19, 34);
        this.oldStopDate = originalName.substring(35, 50);
        this.version = originalName.substring(50, 55);
        this.oldCounter = originalName.substring(55, 58);
        this.suffix = originalName.substring(58, originalName.length());
    }

    void setStartDate(Date startDate) {
        this.newStartDate = DateTimeUtils.toFileNameFormat((Date)startDate);
    }

    void setStopDate(Date stopDate) {
        this.newStopDate = DateTimeUtils.toFileNameFormat((Date)stopDate);
    }

    void setFileCounter(int counter) {
        this.fileCounter = counter;
    }

    String getHdrFileName() {
        StringBuffer buffer = this.getFileNameBufferWithoutExtension();
        buffer.append(".HDR");
        return buffer.toString();
    }

    String getDblFileName() {
        StringBuffer buffer = this.getFileNameBufferWithoutExtension();
        buffer.append(".DBL");
        return buffer.toString();
    }

    String getFileNameWithoutExtension() {
        return this.getFileNameBufferWithoutExtension().toString();
    }

    StringBuffer getFileNameBufferWithoutExtension() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.prefix);
        if (this.newStartDate != null) {
            buffer.append(this.newStartDate);
        } else {
            buffer.append(this.oldStartDate);
        }
        buffer.append("_");
        if (this.newStopDate != null) {
            buffer.append(this.newStopDate);
        } else {
            buffer.append(this.oldStopDate);
        }
        buffer.append(this.version);
        if (this.fileCounter != 0) {
            DecimalFormat decimalFormat = new DecimalFormat("000");
            String counterString = decimalFormat.format(this.fileCounter);
            int length = counterString.length();
            buffer.append(counterString.substring(length - 3, length));
        } else {
            buffer.append(this.oldCounter);
        }
        buffer.append(this.suffix);
        return buffer;
    }
}

