/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.esa.smos.DateTimeUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class EEHdrFilePatcher {
    private Date sensingStart = null;
    private Date sensingStop = null;
    private String fileName = null;
    private Rectangle2D area = null;
    private long gridPointCount = 0L;

    EEHdrFilePatcher() {
    }

    final void patch(File sourceHdrFile, File targetHdrFile) throws IOException {
        this.patch(new FileInputStream(sourceHdrFile), new FileOutputStream(targetHdrFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void patch(InputStream sourceStream, OutputStream targetStream) throws IOException {
        Document sourceDocument;
        try {
            sourceDocument = new SAXBuilder().build(sourceStream);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage(), e);
        }
        Document targetDocument = this.patchDocument(sourceDocument);
        try {
            Format format = this.getFormat();
            XMLOutputter serializer = new XMLOutputter(format);
            serializer.output(targetDocument, targetStream);
        }
        finally {
            targetStream.close();
        }
    }

    void setSensingPeriod(Date sensingStart, Date sensingStop) {
        this.sensingStart = sensingStart;
        this.sensingStop = sensingStop;
    }

    void setFileName(String fileName) {
        this.fileName = fileName;
    }

    void setArea(Rectangle2D area) {
        this.area = area;
    }

    void setGridPointCount(long gridPointCount) {
        this.gridPointCount = gridPointCount;
    }

    final Format getFormat() {
        return Format.getRawFormat().setOmitEncoding(true).setLineSeparator("\n");
    }

    Document patchDocument(Document document) {
        Element element = document.getRootElement();
        Namespace namespace = element.getNamespace();
        this.patchFixedHeader(element, namespace);
        this.patchVariableHeader(element, namespace);
        return document;
    }

    private void patchVariableHeader(Element element, Namespace namespace) {
        DecimalFormat numberFormat;
        Element variableHeader = element.getChild("Variable_Header", namespace);
        Element specificHeader = variableHeader.getChild("Specific_Product_Header", namespace);
        Element mainInfo = specificHeader.getChild("Main_Info", namespace);
        Element timeInfo = null;
        if (mainInfo != null) {
            timeInfo = mainInfo.getChild("Time_Info", namespace);
        }
        if (this.sensingStart != null && timeInfo != null) {
            Element validityStart = timeInfo.getChild("Precise_Validity_Start", namespace);
            validityStart.setText(DateTimeUtils.toVariableHeaderFormat((Date)this.sensingStart));
        }
        if (this.sensingStop != null && timeInfo != null) {
            Element validityStop = timeInfo.getChild("Precise_Validity_Stop", namespace);
            validityStop.setText(DateTimeUtils.toVariableHeaderFormat((Date)this.sensingStop));
        }
        if (this.area != null) {
            numberFormat = this.createDecimalFormat();
            Element productLocation = specificHeader.getChild("Product_Location", namespace);
            if (productLocation == null) {
                productLocation = specificHeader.getChild("L2_Product_Location", namespace);
            }
            this.patchGeolocation(namespace, numberFormat, productLocation);
        }
        if (this.gridPointCount > 0L) {
            numberFormat = new DecimalFormat("0000000000");
            Element listOfDatasets = specificHeader.getChild("List_of_Data_Sets", namespace);
            List children = listOfDatasets.getChildren();
            Iterator dsIterator = children.iterator();
            long offset = 0L;
            while (dsIterator.hasNext()) {
                Element dataSet = (Element)dsIterator.next();
                Element dsSizeElement = dataSet.getChild("DS_Size", namespace);
                String sizeString = dsSizeElement.getText();
                int size = Integer.parseInt(sizeString);
                if (size == 0) continue;
                String dsNameString = dataSet.getChildText("DS_Name", namespace);
                if ("Swath_Snapshot_List".equalsIgnoreCase(dsNameString)) {
                    offset += (long)size;
                    continue;
                }
                String dsrSizeString = dataSet.getChildText("DSR_Size", namespace);
                long dsrSize = Long.parseLong(dsrSizeString);
                long dsSize = dsrSize * this.gridPointCount;
                dsSizeElement.setText(numberFormat.format(dsSize));
                Element dsOffsetElement = dataSet.getChild("DS_Offset", namespace);
                dsOffsetElement.setText(numberFormat.format(offset));
                offset += dsSize;
                Element numDsrElement = dataSet.getChild("Num_DSR", namespace);
                numDsrElement.setText(numberFormat.format(this.gridPointCount));
            }
        }
    }

    private void patchGeolocation(Namespace namespace, DecimalFormat numberFormat, Element productLocation) {
        Element startLat = productLocation.getChild("Start_Lat", namespace);
        startLat.setText(numberFormat.format(this.area.getMaxY()));
        Element startLon = productLocation.getChild("Start_Lon", namespace);
        if (startLon == null) {
            startLon = productLocation.getChild("Start_Long", namespace);
        }
        startLon.setText(numberFormat.format(this.area.getMinX()));
        Element stopLat = productLocation.getChild("Stop_Lat", namespace);
        stopLat.setText(numberFormat.format(this.area.getMinY()));
        Element stopLon = productLocation.getChild("Stop_Lon", namespace);
        if (stopLon == null) {
            stopLon = productLocation.getChild("Stop_Long", namespace);
        }
        stopLon.setText(numberFormat.format(this.area.getMaxX()));
        Element midLat = productLocation.getChild("Mid_Lat", namespace);
        midLat.setText(numberFormat.format(this.area.getMinY() + 0.5 * (this.area.getMaxY() - this.area.getMinY())));
        Element midLon = productLocation.getChild("Mid_Lon", namespace);
        if (midLon == null) {
            midLon = productLocation.getChild("Mid_Long", namespace);
        }
        midLon.setText(numberFormat.format(this.area.getMinX() + 0.5 * (this.area.getMaxX() - this.area.getMinX())));
    }

    private DecimalFormat createDecimalFormat() {
        DecimalFormat numberFormat = new DecimalFormat("+000.000000;-000.000000");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        numberFormat.setDecimalFormatSymbols(symbols);
        return numberFormat;
    }

    private void patchFixedHeader(Element element, Namespace namespace) {
        Element fixedHeader = element.getChild("Fixed_Header", namespace);
        if (this.fileName != null) {
            Element fileNameField = fixedHeader.getChild("File_Name", namespace);
            fileNameField.setText(this.fileName);
        }
        Element validityPeriod = fixedHeader.getChild("Validity_Period", namespace);
        if (this.sensingStart != null) {
            Element validityStart = validityPeriod.getChild("Validity_Start", namespace);
            validityStart.setText(DateTimeUtils.toFixedHeaderFormat((Date)this.sensingStart));
        }
        if (this.sensingStop != null) {
            Element validityStop = validityPeriod.getChild("Validity_Stop", namespace);
            validityStop.setText(DateTimeUtils.toFixedHeaderFormat((Date)this.sensingStop));
        }
    }
}

