/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import java.io.File;
import java.io.IOException;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.gui.export.EEExportGridPointHandler;
import org.esa.smos.gui.export.EEHdrFilePatcher;
import org.esa.smos.gui.export.FileNamePatcher;
import org.esa.smos.gui.export.GridPointFilterStream;
import org.esa.snap.core.util.io.FileUtils;

public class EEExportStream
implements GridPointFilterStream {
    private final File targetDirectory;
    private final int fileCounter;
    private DataContext targetContext;
    private EEExportGridPointHandler targetGridPointHandler;
    private File targetDblFile;
    private File targetHdrFile;

    public EEExportStream(File targetDirectory) {
        this.targetDirectory = targetDirectory;
        this.fileCounter = 0;
    }

    public EEExportStream(File targetDirectory, int fileCounter) {
        this.targetDirectory = targetDirectory;
        this.fileCounter = fileCounter;
    }

    @Override
    public void startFile(SmosFile sourceFile) throws IOException {
        this.targetDblFile = this.getTargetDblFile(sourceFile.getDataFile());
        this.targetHdrFile = this.getTargetHdrFile(sourceFile.getHeaderFile());
        DataFormat targetFormat = sourceFile.getDataFormat();
        this.targetDblFile.getParentFile().mkdirs();
        this.targetContext = targetFormat.createContext(this.targetDblFile, "rw");
        this.targetGridPointHandler = new EEExportGridPointHandler(this.targetContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFile(SmosFile sourceFile) throws IOException {
        long gridPointCount = this.targetGridPointHandler.getGridPointCount();
        boolean validPeriod = this.targetGridPointHandler.hasValidPeriod();
        boolean validArea = this.targetGridPointHandler.hasValidArea();
        FileNamePatcher fileNamePatcher = new FileNamePatcher(FileUtils.getFilenameWithoutExtension((File)this.targetDblFile));
        fileNamePatcher.setFileCounter(this.fileCounter);
        EEHdrFilePatcher hdrFilePatcher = new EEHdrFilePatcher();
        hdrFilePatcher.setFileName(fileNamePatcher.getFileNameWithoutExtension());
        hdrFilePatcher.setGridPointCount(gridPointCount);
        try {
            if (validPeriod) {
                fileNamePatcher.setStartDate(this.targetGridPointHandler.getSensingStart());
                fileNamePatcher.setStopDate(this.targetGridPointHandler.getSensingStop());
                hdrFilePatcher.setSensingPeriod(this.targetGridPointHandler.getSensingStart(), this.targetGridPointHandler.getSensingStop());
            }
            if (validArea) {
                hdrFilePatcher.setArea(this.targetGridPointHandler.getArea());
            }
            hdrFilePatcher.patch(sourceFile.getHeaderFile(), this.targetHdrFile);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException iOException) {}
            if (gridPointCount == 0L) {
                File parentDir = this.targetHdrFile.getParentFile();
                this.targetHdrFile.delete();
                this.targetDblFile.delete();
                parentDir.delete();
            } else {
                this.renameFiles(fileNamePatcher);
            }
        }
    }

    @Override
    public void handleGridPoint(int id, CompoundData gridPointData) throws IOException {
        this.targetGridPointHandler.handleGridPoint(id, gridPointData);
    }

    @Override
    public void close() throws IOException {
        if (this.targetContext != null) {
            this.targetContext.dispose();
            this.targetContext = null;
        }
        this.targetGridPointHandler = null;
    }

    public File getTargetDblFile() {
        return this.targetDblFile;
    }

    public File getTargetHdrFile() {
        return this.targetHdrFile;
    }

    private void renameFiles(FileNamePatcher fileNamePatcher) throws IOException {
        File oldDir = this.targetHdrFile.getParentFile();
        File newDir = new File(oldDir.getParent(), fileNamePatcher.getFileNameWithoutExtension());
        this.renameFile(oldDir, newDir);
        File newHdrFile = new File(newDir, fileNamePatcher.getHdrFileName());
        File oldHdrFile = new File(newDir, this.targetHdrFile.getName());
        this.renameFile(oldHdrFile, newHdrFile);
        File newDblFile = new File(newDir, fileNamePatcher.getDblFileName());
        File oldDblFile = new File(newDir, this.targetDblFile.getName());
        this.renameFile(oldDblFile, newDblFile);
        this.targetHdrFile = newHdrFile;
        this.targetDblFile = newDblFile;
    }

    private void renameFile(File oldFile, File newFile) throws IOException {
        String oldPath = oldFile.getPath();
        String newPath = newFile.getPath();
        if (!newFile.equals(oldFile)) {
            if (newFile.exists()) {
                throw new IOException(String.format("File \n'%s'\ncould not be renamed to\n'%s'\nbecause the latter was already existing.", oldPath, newPath));
            }
            if (!oldFile.renameTo(newFile)) {
                throw new IOException(String.format("File \n'%s'\ncould not be renamed to\n'%s'.", oldPath, newPath));
            }
        }
    }

    private File getTargetDblFile(File sourceDblFile) {
        return new File(new File(this.targetDirectory, sourceDblFile.getParentFile().getName()), sourceDblFile.getName());
    }

    private File getTargetHdrFile(File sourceHdrFile) {
        return new File(new File(this.targetDirectory, sourceHdrFile.getParentFile().getName()), sourceHdrFile.getName());
    }
}

