/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.esa.smos.DateTimeUtils;
import org.esa.smos.SmosUtils;
import org.esa.smos.gui.export.GeometryTracker;
import org.esa.smos.gui.export.GridPointFilter;
import org.esa.smos.gui.export.GridPointHandler;
import org.esa.smos.gui.export.TimeTracker;

class EEExportGridPointHandler
implements GridPointHandler {
    private final DataContext targetContext;
    private final GridPointFilter targetFilter;
    private final HashMap<Long, Date> snapshotIdTimeMap;
    private final TimeTracker timeTracker;
    private final GeometryTracker geometryTracker;
    private boolean level2;
    private long gridPointCount;
    private long gridPointDataPosition;
    private int latIndex;
    private int lonIndex;
    private static final int SEGMENT_SIZE = 16384;

    EEExportGridPointHandler(DataContext targetContext) {
        this(targetContext, new GridPointFilter(){

            @Override
            public boolean accept(int id, CompoundData gridPointData) throws IOException {
                return true;
            }
        });
    }

    EEExportGridPointHandler(DataContext targetContext, GridPointFilter targetFilter) {
        this.targetContext = targetContext;
        this.targetFilter = targetFilter;
        this.snapshotIdTimeMap = new HashMap();
        this.timeTracker = new TimeTracker();
        this.geometryTracker = new GeometryTracker();
        String formatName = targetContext.getFormat().getName();
        this.level2 = SmosUtils.isL2Format((String)formatName);
    }

    @Override
    public void handleGridPoint(int id, CompoundData gridPointData) throws IOException {
        if (this.gridPointCount == 0L) {
            this.init(gridPointData);
        }
        if (this.targetFilter.accept(id, gridPointData)) {
            this.trackSensingTime(gridPointData);
            this.trackGeometry(gridPointData);
            this.targetContext.getData().setLong("Grid_Point_Counter", ++this.gridPointCount);
            this.targetContext.getData().flush();
            gridPointData.resolveSize();
            long size = gridPointData.getSize();
            byte[] bytes = new byte[(int)size];
            EEExportGridPointHandler.get(gridPointData, bytes);
            EEExportGridPointHandler.put(this.targetContext, bytes, this.gridPointDataPosition);
            this.gridPointDataPosition += size;
        }
    }

    boolean hasValidPeriod() {
        return this.timeTracker.hasValidPeriod();
    }

    Date getSensingStart() {
        return this.timeTracker.getIntervalStart();
    }

    Date getSensingStop() {
        return this.timeTracker.getIntervalStop();
    }

    boolean hasValidArea() {
        return this.geometryTracker.hasValidArea();
    }

    Rectangle2D getArea() {
        return this.geometryTracker.getArea();
    }

    long getGridPointCount() {
        return this.gridPointCount;
    }

    static Date getL2MjdTimeStamp(CompoundData compoundData) throws IOException {
        int index = compoundData.getType().getMemberIndex("Mean_Acq_Time");
        if (index > 0) {
            return EEExportGridPointHandler.getOSUDPDate(compoundData, index);
        }
        CompoundType type = compoundData.getType();
        index = type.getMemberIndex("Days");
        if (index >= 0) {
            return EEExportGridPointHandler.getSMUPDDate(compoundData);
        }
        return null;
    }

    private static Date getSMUPDDate(CompoundData compoundData) throws IOException {
        long microseconds;
        long seconds;
        int days = compoundData.getInt("Days");
        if ((long)days + (seconds = compoundData.getUInt("Seconds")) + (microseconds = compoundData.getUInt("Microseconds")) == 0L) {
            return null;
        }
        return DateTimeUtils.cfiDateToUtc((int)days, (long)seconds, (long)microseconds);
    }

    private static Date getOSUDPDate(CompoundData compoundData, int index) throws IOException {
        float floatDate = compoundData.getFloat(index);
        if (floatDate > 0.0f) {
            return DateTimeUtils.mjdFloatDateToUtc((float)floatDate);
        }
        return null;
    }

    private void trackSensingTime(CompoundData gridPointData) throws IOException {
        CompoundType type = gridPointData.getType();
        String typeName = type.getName();
        if (typeName.contains("ECMWF")) {
            return;
        }
        if (this.level2) {
            Date timeStamp = EEExportGridPointHandler.getL2MjdTimeStamp(gridPointData);
            if (timeStamp != null) {
                this.timeTracker.track(timeStamp);
            }
        } else {
            int index = type.getMemberIndex("BT_Data");
            SequenceData btDataList = gridPointData.getSequence(index);
            CompoundData btData = btDataList.getCompound(0);
            this.trackTime(btData);
            int elementCount = btDataList.getElementCount();
            btData = btDataList.getCompound(elementCount - 1);
            this.trackTime(btData);
        }
    }

    private void trackTime(CompoundData btData) throws IOException {
        int index = btData.getType().getMemberIndex("Snapshot_ID_of_Pixel");
        if (index >= 0) {
            long snapShotId = btData.getUInt(index);
            this.timeTracker.track(this.snapshotIdTimeMap.get(snapShotId));
        }
    }

    private void trackGeometry(CompoundData gridPointData) throws IOException {
        double lat = gridPointData.getDouble(this.latIndex);
        double lon = gridPointData.getDouble(this.lonIndex);
        if (lon > 180.0) {
            lon -= 360.0;
        }
        this.geometryTracker.add(new Point2D.Double(lon, lat));
    }

    private void init(CompoundData gridPointData) throws IOException {
        CompoundType gridPointType = gridPointData.getType();
        this.latIndex = gridPointType.getMemberIndex("Latitude");
        this.lonIndex = gridPointType.getMemberIndex("Longitude");
        CollectionData parent = gridPointData.getParent();
        long parentPosition = parent.getPosition();
        this.copySnapshotData(parent, parentPosition);
        this.createSnapshotIdMap(parent);
        this.targetContext.getData().setLong("Grid_Point_Counter", 0L);
        this.targetContext.getData().flush();
        this.gridPointDataPosition = parentPosition;
    }

    private void createSnapshotIdMap(CollectionData parent) throws IOException {
        DataContext context = parent.getContext();
        int snapshotListIndex = context.getData().getMemberIndex("Swath_Snapshot_List");
        if (snapshotListIndex == -1) {
            return;
        }
        SequenceData snapshotData = context.getData().getSequence(snapshotListIndex);
        int snapshotCount = snapshotData.getElementCount();
        for (int i = 0; i < snapshotCount; ++i) {
            CompoundData snapshot = snapshotData.getCompound(i);
            Date snapshotTime = DateTimeUtils.cfiDateToUtc((CompoundData)snapshot);
            long snapshotId = snapshot.getUInt(1);
            this.snapshotIdTimeMap.put(snapshotId, snapshotTime);
        }
    }

    private void copySnapshotData(CollectionData parent, long parentPosition) throws IOException {
        EEExportGridPointHandler.copyBytesTo(parent.getContext(), this.targetContext, parentPosition);
    }

    private static void copyBytesTo(DataContext sourceContext, DataContext targetContext, long to) throws IOException {
        byte[] bytes = new byte[16384];
        for (long pos = 0L; pos < to; pos += 16384L) {
            long remainderSize = to - pos;
            if (remainderSize < 16384L) {
                bytes = new byte[(int)remainderSize];
            }
            EEExportGridPointHandler.get(sourceContext, bytes, pos);
            EEExportGridPointHandler.put(targetContext, bytes, pos);
        }
    }

    private static void get(CompoundData compoundData, byte[] bytes) throws IOException {
        DataContext context = compoundData.getContext();
        long position = compoundData.getPosition();
        context.getHandler().read(context, bytes, position);
    }

    private static void get(DataContext sourceContext, byte[] bytes, long position) throws IOException {
        sourceContext.getHandler().read(sourceContext, bytes, position);
    }

    private static void put(DataContext targetContext, byte[] bytes, long position) throws IOException {
        targetContext.getHandler().write(targetContext, bytes, position);
    }
}

