/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableColumnModelExt;

class TableModelExporter {
    private char separator;
    private final TableModel tableModel;
    private final TableColumnModelExt columnModel;

    TableModelExporter(TableModel tableModel, TableColumnModelExt columnModel) {
        this.tableModel = tableModel;
        this.columnModel = columnModel;
        this.separator = (char)44;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void export(OutputStream out) {
        try (PrintWriter writer = new PrintWriter(out);){
            this.writeHeaderRow(writer);
            this.writeDataRows(writer);
        }
    }

    private void writeHeaderRow(PrintWriter out) {
        int visibleColumnCount = this.columnModel.getColumnCount(false);
        for (int columnIndex = 0; columnIndex < visibleColumnCount; ++columnIndex) {
            TableColumn column = this.columnModel.getColumn(columnIndex);
            out.print(column.getHeaderValue());
            if (columnIndex >= visibleColumnCount - 1) continue;
            out.print(this.getSeparator());
        }
        out.println();
    }

    private void writeDataRows(PrintWriter out) {
        int visibleColumnCount = this.columnModel.getColumnCount(false);
        int rowCount = this.tableModel.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < visibleColumnCount; ++columnIndex) {
                TableColumn column = this.columnModel.getColumn(columnIndex);
                int modelIndex = column.getModelIndex();
                out.print(this.tableModel.getValueAt(rowIndex, modelIndex));
                if (columnIndex >= visibleColumnCount - 1) continue;
                out.print(this.getSeparator());
            }
            out.println();
        }
    }
}

