/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.gui.SceneViewSelectionService;
import org.esa.smos.gui.SmosBox;
import org.esa.smos.gui.snapshot.SnapshotSelectionService;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.actions.help.HelpAction;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public abstract class SmosTopComponent
extends TopComponent {
    private static final String HELP_ID = "smosIntroduction";
    private JPanel panel;
    private JLabel defaultComponent;
    private JComponent clientComponent;
    private SVSL svsl;

    public SmosTopComponent() {
        JComponent component = this.initUi();
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
    }

    protected final SceneViewSelectionService getSmosViewSelectionService() {
        return SmosBox.getInstance().getSmosViewSelectionService();
    }

    protected final SnapshotSelectionService getSnapshotSelectionService() {
        return SmosBox.getInstance().getSnapshotSelectionService();
    }

    protected final ProductSceneView getSelectedSmosView() {
        return this.getSmosViewSelectionService().getSelectedSceneView();
    }

    protected final Product getSelectedSmosProduct() {
        return this.getSmosViewSelectionService().getSelectedSmosProduct();
    }

    protected final SmosReader getSelectedSmosReader() {
        return this.getSmosViewSelectionService().getSelectedSmosReader();
    }

    protected final long getSelectedSnapshotId(RasterDataNode raster) {
        return this.getSnapshotSelectionService().getSelectedSnapshotId(raster);
    }

    protected final long getSelectedSnapshotId(ProductSceneView view) {
        RasterDataNode raster = view != null ? view.getRaster() : null;
        return this.getSnapshotSelectionService().getSelectedSnapshotId(raster);
    }

    protected final void setSelectedSnapshotId(RasterDataNode raster, long id) {
        this.getSnapshotSelectionService().setSelectedSnapshotId(raster, id);
    }

    protected JComponent initUi() {
        this.panel = new JPanel(new BorderLayout());
        Image image = ImageUtilities.loadImage((String)"org/esa/smos/icons/SmosIcon.png", (boolean)false);
        this.defaultComponent = image != null ? new JLabel(new ImageIcon(image)) : new JLabel();
        this.defaultComponent.setIconTextGap(10);
        this.defaultComponent.setText("No SMOS image selected.");
        this.panel.add((Component)this.defaultComponent, "Center");
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public void componentOpened() {
        this.svsl = new SVSL();
        this.getSmosViewSelectionService().addSceneViewSelectionListener(this.svsl);
        this.realizeSmosView(this.getSelectedSmosView());
    }

    public void componentClosed() {
        this.getSmosViewSelectionService().removeSceneViewSelectionListener(this.svsl);
        this.realizeSmosView(null);
    }

    public void componentShowing() {
        this.realizeSmosView(this.getSelectedSmosView());
    }

    public void componentHidden() {
        this.realizeSmosView(null);
    }

    protected void realizeSmosView(ProductSceneView view) {
        if (view != null) {
            if (this.clientComponent == null) {
                this.clientComponent = this.createClientComponent();
            }
            this.setToolViewComponent(this.clientComponent);
            this.updateClientComponent(view);
        } else {
            this.setToolViewComponent(this.defaultComponent);
        }
    }

    protected final JComponent getClientComponent() {
        return this.clientComponent != null ? this.clientComponent : this.defaultComponent;
    }

    protected JComponent getDefaultComponent() {
        return this.defaultComponent;
    }

    protected abstract JComponent createClientComponent();

    protected abstract void updateClientComponent(ProductSceneView var1);

    protected final void setToolViewComponent(JComponent comp) {
        this.panel.removeAll();
        this.panel.add((Component)comp, "Center");
        this.panel.invalidate();
        this.panel.validate();
        this.panel.updateUI();
    }

    protected AbstractButton createHelpButton() {
        AbstractButton helpButton = ToolButtonFactory.createButton((Action)new HelpAction((HelpCtx.Provider)this), (boolean)false);
        helpButton.setName("helpButton");
        return helpButton;
    }

    private class SVSL
    implements SceneViewSelectionService.SelectionListener {
        private SVSL() {
        }

        @Override
        public void handleSceneViewSelectionChanged(ProductSceneView oldView, ProductSceneView newView) {
            SmosTopComponent.this.realizeSmosView(newView);
        }
    }
}

