/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.gui.SmosBox;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NonNull;

public class SceneViewSelectionService
extends ToolTopComponent {
    private final List<SelectionListener> selectionListeners;
    private final PPL ppl = new PPL();
    private ProductSceneView selectedSceneView;

    public SceneViewSelectionService() {
        this.selectionListeners = new ArrayList<SelectionListener>();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void productSceneViewSelected(@NonNull ProductSceneView view) {
        this.setSelectedSceneView(view);
    }

    protected void productSceneViewDeselected(@NonNull ProductSceneView view) {
        this.setSelectedSceneView(null);
    }

    public void stop() {
        this.selectionListeners.clear();
    }

    public ProductSceneView getSelectedSceneView() {
        return this.selectedSceneView;
    }

    private void setSelectedSceneView(ProductSceneView newView) {
        ProductSceneView oldView = this.selectedSceneView;
        if (oldView != newView) {
            if (oldView != null) {
                oldView.removePixelPositionListener((PixelPositionListener)this.ppl);
            }
            if (newView != null) {
                Product product = newView.getProduct();
                if (product == null) {
                    return;
                }
                if (!(product.getProductReader() instanceof SmosReader)) {
                    return;
                }
            }
            this.selectedSceneView = newView;
            this.fireSelectionChange(oldView, newView);
            if (this.selectedSceneView != null) {
                this.selectedSceneView.addPixelPositionListener((PixelPositionListener)this.ppl);
            }
        }
    }

    public Product getSelectedSmosProduct() {
        ProductSceneView sceneView = this.getSelectedSceneView();
        return sceneView != null ? sceneView.getProduct() : null;
    }

    public SmosReader getSelectedSmosReader() {
        ProductReader productReader;
        Product product = this.getSelectedSmosProduct();
        if (product != null && (productReader = product.getProductReader()) instanceof SmosReader) {
            return (SmosReader)productReader;
        }
        return null;
    }

    public int getGridPointId(int pixelX, int pixelY) {
        return this.getGridPointId(pixelX, pixelY, 0);
    }

    public int getGridPointId(int pixelX, int pixelY, int currentLevel) {
        SmosReader smosReader = this.getSelectedSmosReader();
        if (smosReader != null) {
            return smosReader.getGridPointId(pixelX, pixelY, currentLevel);
        }
        return -1;
    }

    public synchronized void addSceneViewSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public synchronized void removeSceneViewSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void fireSelectionChange(ProductSceneView oldView, ProductSceneView newView) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.handleSceneViewSelectionChanged(oldView, newView);
        }
    }

    private class PPL
    implements PixelPositionListener {
        private PPL() {
        }

        public void pixelPosChanged(ImageLayer baseImageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            int seqnum = -1;
            if (pixelPosValid) {
                seqnum = SceneViewSelectionService.this.getGridPointId(pixelX, pixelY, currentLevel);
            }
            SmosBox.getInstance().getGridPointSelectionService().setSelectedGridPointId(seqnum);
        }

        public void pixelPosNotAvailable() {
            SmosBox.getInstance().getGridPointSelectionService().setSelectedGridPointId(-1);
        }
    }

    public static interface SelectionListener {
        public void handleSceneViewSelectionChanged(ProductSceneView var1, ProductSceneView var2);
    }
}

