/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import java.util.Arrays;
import java.util.Collections;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.gui.swing.SnapshotSelectorComboModel;
import org.esa.smos.gui.swing.SnapshotSelectorModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotSelectorComboModelTest {
    private SnapshotSelectorComboModel selectorComboModel;

    @Before
    public void before() throws Exception {
        this.selectorComboModel = SnapshotSelectorComboModelTest.createSnapshotSelectorComboModel();
    }

    @Test
    public void testInitialState() {
        Assert.assertEquals((long)3L, (long)this.selectorComboModel.getSize());
        Assert.assertEquals((Object)"Any", (Object)this.selectorComboModel.getSelectedItem());
    }

    @Test
    public void testModeSelection() {
        SnapshotSelectorModel modelA = this.selectorComboModel.getSelectedModel();
        this.selectorComboModel.setSelectedItem((Object)"X");
        SnapshotSelectorModel modelX = this.selectorComboModel.getSelectedModel();
        this.selectorComboModel.setSelectedItem((Object)"Y");
        SnapshotSelectorModel modelY = this.selectorComboModel.getSelectedModel();
        Assert.assertNotSame((Object)modelA, (Object)modelX);
        Assert.assertNotSame((Object)modelA, (Object)modelY);
        Assert.assertNotSame((Object)modelX, (Object)modelY);
    }

    @Test
    public void testSnapshotIdIsPreservedIfPossible() {
        SnapshotSelectorModel modelA = this.selectorComboModel.getSelectedModel();
        modelA.setSnapshotId(3L);
        this.selectorComboModel.setSelectedItem((Object)"X");
        SnapshotSelectorModel modelX = this.selectorComboModel.getSelectedModel();
        Assert.assertEquals((long)3L, (long)modelX.getSnapshotId());
        this.selectorComboModel.setSelectedItem((Object)"Y");
        SnapshotSelectorModel modelY = this.selectorComboModel.getSelectedModel();
        Assert.assertEquals((long)2L, (long)modelY.getSnapshotId());
        this.selectorComboModel.setSelectedItem((Object)"Any");
        Assert.assertEquals((long)2L, (long)modelA.getSnapshotId());
    }

    static SnapshotSelectorComboModel createSnapshotSelectorComboModel() {
        return new SnapshotSelectorComboModel(new SnapshotInfo(Collections.emptyMap(), Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), Arrays.asList(1L, 3L, 5L, 7L), Arrays.asList(2L, 4L, 6L, 8L), Arrays.asList(new Long[0]), Collections.emptyMap()));
    }
}

