/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.snapshot;

import org.esa.smos.gui.snapshot.SnapshotInfoTopComponent;
import org.esa.snap.core.datamodel.Band;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotInfoToolViewTest {
    @Test
    public void testIsXPolarized() {
        Band band = this.createband("BT_Value_X");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isXPolarized((Band)band));
        band = this.createband("Faraday_Rotation_Angle_X");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isXPolarized((Band)band));
        band = this.createband("Faraday_Rotation_Angle_Y");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isXPolarized((Band)band));
        band = this.createband("BT_Value_V");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isXPolarized((Band)band));
    }

    @Test
    public void testIsYPolarized() {
        Band band = this.createband("Geometric_Rotation_Angle_Y");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isYPolarized((Band)band));
        band = this.createband("Footprint_Axis_1_Y");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isYPolarized((Band)band));
        band = this.createband("Footprint_Axis_2_XY");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isYPolarized((Band)band));
        band = this.createband("BT_Value_HV_Real");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isYPolarized((Band)band));
    }

    @Test
    public void testIsXYPolarized() {
        Band band = this.createband("BT_Value_XY_Real");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isXYPolarized((Band)band));
        band = this.createband("Pixel_Radiometric_accuracy_XY");
        Assert.assertTrue((boolean)SnapshotInfoTopComponent.isXYPolarized((Band)band));
        band = this.createband("Azimuth_Angle_X");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isXYPolarized((Band)band));
        band = this.createband("BT_Value_H");
        Assert.assertFalse((boolean)SnapshotInfoTopComponent.isXYPolarized((Band)band));
    }

    private Band createband(String name) {
        return new Band(name, 10, 4, 4);
    }
}

