/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import org.esa.smos.gui.gridpoint.GridPointSelectionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GridPointSelectionServiceTest {
    private GridPointSelectionService service;

    @Before
    public void setUp() {
        this.service = new GridPointSelectionService();
    }

    @Test
    public void testGetSelectedGridPoint_initialValue() {
        Assert.assertEquals((long)-1L, (long)this.service.getSelectedGridPointId());
    }

    @Test
    public void testSetGetSelectedGridPoint() {
        this.service.setSelectedGridPointId(108);
        Assert.assertEquals((long)108L, (long)this.service.getSelectedGridPointId());
    }

    @Test
    public void testSetGetSelectedGridPoint_stopService() {
        this.service.setSelectedGridPointId(108);
        Assert.assertEquals((long)108L, (long)this.service.getSelectedGridPointId());
        this.service.stop();
        Assert.assertEquals((long)-1L, (long)this.service.getSelectedGridPointId());
    }

    @Test
    public void testAddListener_dispatchUpdate() {
        GridPointSelectionService.SelectionListener listener = (GridPointSelectionService.SelectionListener)Mockito.mock(GridPointSelectionService.SelectionListener.class);
        this.service.addGridPointSelectionListener(listener);
        this.service.setSelectedGridPointId(76);
        ((GridPointSelectionService.SelectionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).handleGridPointSelectionChanged(-1, 76);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddListener_doesNotDispatchWhenIdsAreSame() {
        GridPointSelectionService.SelectionListener listener = (GridPointSelectionService.SelectionListener)Mockito.mock(GridPointSelectionService.SelectionListener.class);
        this.service.addGridPointSelectionListener(listener);
        this.service.setSelectedGridPointId(76);
        this.service.setSelectedGridPointId(76);
        ((GridPointSelectionService.SelectionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).handleGridPointSelectionChanged(-1, 76);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testAddListener_removeListener() {
        GridPointSelectionService.SelectionListener listener = (GridPointSelectionService.SelectionListener)Mockito.mock(GridPointSelectionService.SelectionListener.class);
        this.service.addGridPointSelectionListener(listener);
        this.service.removeGridPointSelectionListener(listener);
        this.service.setSelectedGridPointId(76);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }
}

