/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.util.HashMap;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.gui.gridpoint.GridPointBtDataTableModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridPointBtDataTableModelTest {
    private GridPointBtDataTableModel model;

    @Before
    public void setUp() {
        this.model = new GridPointBtDataTableModel();
    }

    @Test
    public void testCreate_defaultValues() {
        Assert.assertEquals((long)0L, (long)this.model.getRowCount());
        Assert.assertEquals((long)0L, (long)this.model.getColumnCount());
        Assert.assertNull((Object)this.model.getValueAt(0, 5));
        Assert.assertEquals((Object)"", (Object)this.model.getColumnName(3));
        Assert.assertEquals(Number.class, (Object)this.model.getColumnClass(3));
    }

    @Test
    public void testDatasetAccess() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        this.model.setGridPointBtDataset(btDataset);
        Assert.assertEquals((long)2L, (long)this.model.getRowCount());
        Assert.assertEquals((Object)6, (Object)this.model.getValueAt(0, 2));
        Assert.assertEquals((Object)8, (Object)this.model.getValueAt(1, 1));
        Assert.assertEquals(String.class, (Object)this.model.getColumnClass(1));
        Assert.assertEquals(Double.class, (Object)this.model.getColumnClass(2));
    }

    @Test
    public void testGetValueAt_specialZeroColumnTreatment() {
        Assert.assertEquals((Object)5, (Object)this.model.getValueAt(4, 0));
        Assert.assertEquals((Object)2, (Object)this.model.getValueAt(1, 0));
    }

    @Test
    public void testGetColumnClass_specialZeroColumnTreatment() {
        Assert.assertEquals(Integer.class, (Object)this.model.getColumnClass(0));
    }

    @Test
    public void testColumnAccess() {
        Object[] columnNames = new String[]{"one", "two", "three", "four"};
        this.model.setColumnNames((String[])columnNames);
        Assert.assertEquals((long)5L, (long)this.model.getColumnCount());
        Assert.assertEquals((Object)"three", (Object)this.model.getColumnName(3));
        Assert.assertArrayEquals((Object[])columnNames, (Object[])this.model.getColumnNames());
    }

    @Test
    public void testGetIndex() {
        GridPointBtDataset btDataset = this.createGridPointBtDataset();
        this.model.setGridPointBtDataset(btDataset);
        Assert.assertEquals((long)3L, (long)this.model.getIndex("Fritz"));
        Assert.assertEquals((long)1L, (long)this.model.getIndex("Heini"));
    }

    @Test
    public void testColumnAccess_specialZeroColumnTreatment() {
        Assert.assertEquals((Object)"Rec#", (Object)this.model.getColumnName(0));
    }

    private GridPointBtDataset createGridPointBtDataset() {
        HashMap<String, Integer> memberNamesMap = new HashMap<String, Integer>();
        memberNamesMap.put("Heini", 1);
        memberNamesMap.put("Veronika", 2);
        memberNamesMap.put("Fritz", 3);
        memberNamesMap.put("Walburga", 4);
        Class[] classes = new Class[]{String.class, Double.class};
        Number[][] data = new Number[][]{{5, 6, 7}, {8, 9, 10}};
        return new GridPointBtDataset(memberNamesMap, classes, data);
    }
}

