/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.util.Date;
import org.esa.smos.gui.export.TimeTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeTrackerTest {
    private TimeTracker timeTracker;

    @Before
    public void setUp() {
        this.timeTracker = new TimeTracker();
    }

    @Test
    public void testCreateAndGet() {
        Date start = this.timeTracker.getIntervalStart();
        Assert.assertEquals((Object)new Date(Long.MAX_VALUE), (Object)start);
        Date stop = this.timeTracker.getIntervalStop();
        Assert.assertEquals((Object)new Date(Long.MIN_VALUE), (Object)stop);
    }

    @Test
    public void testTrackOneDate() {
        Date date = new Date(300L);
        this.timeTracker.track(date);
        Assert.assertEquals((Object)date, (Object)this.timeTracker.getIntervalStart());
        Assert.assertEquals((Object)date, (Object)this.timeTracker.getIntervalStop());
    }

    @Test
    public void testTrackTwoDates() {
        Date date_1 = new Date(4000L);
        Date date_2 = new Date(5000L);
        this.timeTracker.track(date_1);
        this.timeTracker.track(date_2);
        Assert.assertEquals((Object)date_1, (Object)this.timeTracker.getIntervalStart());
        Assert.assertEquals((Object)date_2, (Object)this.timeTracker.getIntervalStop());
    }

    @Test
    public void testTrackThreeDates() {
        Date date_1 = new Date(11000L);
        Date date_2 = new Date(10000L);
        Date date_3 = new Date(9000L);
        this.timeTracker.track(date_2);
        this.timeTracker.track(date_3);
        this.timeTracker.track(date_1);
        Assert.assertEquals((Object)date_3, (Object)this.timeTracker.getIntervalStart());
        Assert.assertEquals((Object)date_1, (Object)this.timeTracker.getIntervalStop());
    }

    @Test
    public void testTrackNullDate() {
        try {
            this.timeTracker.track(null);
        }
        catch (Exception e) {
            Assert.fail((String)"no exception expected");
        }
        Assert.assertFalse((boolean)this.timeTracker.hasValidPeriod());
    }

    @Test
    public void testHasValidPeriod_noDates() {
        Assert.assertFalse((boolean)this.timeTracker.hasValidPeriod());
    }

    @Test
    public void testHasValidPeriod_oneDate() {
        this.timeTracker.track(new Date(2000L));
        Assert.assertTrue((boolean)this.timeTracker.hasValidPeriod());
    }

    @Test
    public void testHasValidPeriod_twoDate() {
        this.timeTracker.track(new Date(2100L));
        this.timeTracker.track(new Date(2000L));
        Assert.assertTrue((boolean)this.timeTracker.hasValidPeriod());
    }
}

