/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.io.File;
import java.lang.reflect.Field;
import org.esa.smos.gui.export.GridPointExportParameter;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridPointExportParameterTest {
    private GridPointExportParameter gridPointExportParameter;

    @Before
    public void setUp() {
        this.gridPointExportParameter = new GridPointExportParameter();
    }

    @Test
    public void testSetIsUseSelectedProduct() {
        this.gridPointExportParameter.setUseSelectedProduct(true);
        Assert.assertTrue((boolean)this.gridPointExportParameter.isUseSelectedProduct());
        this.gridPointExportParameter.setUseSelectedProduct(false);
        Assert.assertFalse((boolean)this.gridPointExportParameter.isUseSelectedProduct());
    }

    @Test
    public void testUseSelectedProductAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("useSelectedProduct");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"useSelectedProduct", (Object)parameter.alias());
    }

    @Test
    public void testSetGetSourceDirectory() {
        File sourceDirectory = new File("where/ever/my/source");
        this.gridPointExportParameter.setSourceDirectory(sourceDirectory);
        Assert.assertEquals((Object)sourceDirectory.getPath(), (Object)this.gridPointExportParameter.getSourceDirectory().getPath());
    }

    @Test
    public void testSourceDirectoryAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("sourceDirectory");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"sourceDirectory", (Object)parameter.alias());
    }

    @Test
    public void testSetIsOpenFileDialog() {
        this.gridPointExportParameter.setOpenFileDialog(true);
        Assert.assertTrue((boolean)this.gridPointExportParameter.isOpenFileDialog());
        this.gridPointExportParameter.setOpenFileDialog(false);
        Assert.assertFalse((boolean)this.gridPointExportParameter.isOpenFileDialog());
    }

    @Test
    public void testOpenFileDialogAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("openFileDialog");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"openFileDialog", (Object)parameter.alias());
    }

    @Test
    public void testSetIsRecursive() {
        this.gridPointExportParameter.setRecursive(true);
        Assert.assertTrue((boolean)this.gridPointExportParameter.isRecursive());
        this.gridPointExportParameter.setRecursive(false);
        Assert.assertFalse((boolean)this.gridPointExportParameter.isRecursive());
    }

    @Test
    public void testRecursiveAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("recursive");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"recursive", (Object)parameter.alias());
        Assert.assertEquals((Object)"false", (Object)parameter.defaultValue());
    }

    @Test
    public void testSetGetRoiType() {
        this.gridPointExportParameter.setRoiType(5);
        Assert.assertEquals((long)5L, (long)this.gridPointExportParameter.getRoiType());
    }

    @Test
    public void testRoiTypeAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("roiType");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"roiType", (Object)parameter.alias());
        Assert.assertEquals((Object)"2", (Object)parameter.defaultValue());
        Assert.assertArrayEquals((Object[])new String[]{"0", "1", "2"}, (Object[])parameter.valueSet());
    }

    @Test
    public void testSetGetNorth() {
        this.gridPointExportParameter.setNorth(56.22);
        Assert.assertEquals((double)56.22, (double)this.gridPointExportParameter.getNorth(), (double)1.0E-8);
        this.gridPointExportParameter.setNorth(-19.55);
        Assert.assertEquals((double)-19.55, (double)this.gridPointExportParameter.getNorth(), (double)1.0E-8);
    }

    @Test
    public void testNorthAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("north");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"northBound", (Object)parameter.alias());
        Assert.assertEquals((Object)"90.0", (Object)parameter.defaultValue());
        Assert.assertEquals((Object)"[-90.0, 90.0]", (Object)parameter.interval());
    }

    @Test
    public void testSetGetSouth() {
        this.gridPointExportParameter.setSouth(-22.65);
        Assert.assertEquals((double)-22.65, (double)this.gridPointExportParameter.getSouth(), (double)1.0E-8);
        this.gridPointExportParameter.setSouth(3.018);
        Assert.assertEquals((double)3.018, (double)this.gridPointExportParameter.getSouth(), (double)1.0E-8);
    }

    @Test
    public void testSouthAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("south");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"southBound", (Object)parameter.alias());
        Assert.assertEquals((Object)"-90.0", (Object)parameter.defaultValue());
        Assert.assertEquals((Object)"[-90.0, 90.0]", (Object)parameter.interval());
    }

    @Test
    public void testSetGetEast() {
        this.gridPointExportParameter.setEast(29.01);
        Assert.assertEquals((double)29.01, (double)this.gridPointExportParameter.getEast(), (double)1.0E-8);
        this.gridPointExportParameter.setEast(-11.5);
        Assert.assertEquals((double)-11.5, (double)this.gridPointExportParameter.getEast(), (double)1.0E-8);
    }

    @Test
    public void testEastAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("east");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"eastBound", (Object)parameter.alias());
        Assert.assertEquals((Object)"180.0", (Object)parameter.defaultValue());
        Assert.assertEquals((Object)"[-180.0, 180.0]", (Object)parameter.interval());
    }

    @Test
    public void testSetGetWest() {
        this.gridPointExportParameter.setWest(30.02);
        Assert.assertEquals((double)30.02, (double)this.gridPointExportParameter.getWest(), (double)1.0E-8);
        this.gridPointExportParameter.setWest(-12.6);
        Assert.assertEquals((double)-12.6, (double)this.gridPointExportParameter.getWest(), (double)1.0E-8);
    }

    @Test
    public void testWestAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("west");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"westBound", (Object)parameter.alias());
        Assert.assertEquals((Object)"-180.0", (Object)parameter.defaultValue());
        Assert.assertEquals((Object)"[-180.0, 180.0]", (Object)parameter.interval());
    }

    @Test
    public void testSetGetTargetFile() {
        File targetFile = new File("target/file");
        this.gridPointExportParameter.setTargetFile(targetFile);
        Assert.assertEquals((Object)targetFile.getPath(), (Object)this.gridPointExportParameter.getTargetFile().getPath());
    }

    @Test
    public void testTargetFileAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("targetFile");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"targetFileOrDir", (Object)parameter.alias());
        Assert.assertTrue((boolean)parameter.notNull());
        Assert.assertTrue((boolean)parameter.notEmpty());
    }

    @Test
    public void testSetGetExportFormat() {
        this.gridPointExportParameter.setExportFormat("wurst");
        Assert.assertEquals((Object)"wurst", (Object)this.gridPointExportParameter.getExportFormat());
        this.gridPointExportParameter.setExportFormat("xls");
        Assert.assertEquals((Object)"xls", (Object)this.gridPointExportParameter.getExportFormat());
    }

    @Test
    public void testExportFormatAnnotation() throws NoSuchFieldException {
        Field selectedProductField = GridPointExportParameter.class.getDeclaredField("exportFormat");
        Parameter parameter = selectedProductField.getAnnotation(Parameter.class);
        Assert.assertEquals((Object)"exportFormat", (Object)parameter.alias());
        Assert.assertEquals((Object)"CSV", (Object)parameter.defaultValue());
        Assert.assertArrayEquals((Object[])new String[]{"CSV", "Earth Explorer subsets"}, (Object[])parameter.valueSet());
    }

    @Test
    public void testGetClone() {
        File sourceDirectory = new File("source/dir");
        File targetFile = new File("target/file");
        this.gridPointExportParameter.setUseSelectedProduct(true);
        this.gridPointExportParameter.setSourceDirectory(sourceDirectory);
        this.gridPointExportParameter.setOpenFileDialog(true);
        this.gridPointExportParameter.setRecursive(true);
        this.gridPointExportParameter.setRoiType(6);
        this.gridPointExportParameter.setNorth(7.1);
        this.gridPointExportParameter.setSouth(8.2);
        this.gridPointExportParameter.setEast(9.3);
        this.gridPointExportParameter.setWest(10.4);
        this.gridPointExportParameter.setTargetFile(targetFile);
        this.gridPointExportParameter.setExportFormat("word");
        GridPointExportParameter clone = this.gridPointExportParameter.getClone();
        Assert.assertNotNull((Object)clone);
        Assert.assertNotSame((Object)clone, (Object)this.gridPointExportParameter);
        Assert.assertEquals((Object)this.gridPointExportParameter.isUseSelectedProduct(), (Object)clone.isUseSelectedProduct());
        Assert.assertEquals((Object)sourceDirectory.getPath(), (Object)clone.getSourceDirectory().getPath());
        Assert.assertEquals((Object)this.gridPointExportParameter.isOpenFileDialog(), (Object)clone.isOpenFileDialog());
        Assert.assertEquals((Object)this.gridPointExportParameter.isRecursive(), (Object)clone.isRecursive());
        Assert.assertEquals((long)this.gridPointExportParameter.getRoiType(), (long)clone.getRoiType());
        Assert.assertEquals((double)this.gridPointExportParameter.getNorth(), (double)clone.getNorth(), (double)1.0E-8);
        Assert.assertEquals((double)this.gridPointExportParameter.getSouth(), (double)clone.getSouth(), (double)1.0E-8);
        Assert.assertEquals((double)this.gridPointExportParameter.getEast(), (double)clone.getEast(), (double)1.0E-8);
        Assert.assertEquals((double)this.gridPointExportParameter.getWest(), (double)clone.getWest(), (double)1.0E-8);
        Assert.assertEquals((Object)targetFile.getPath(), (Object)clone.getTargetFile().getPath());
        Assert.assertEquals((Object)this.gridPointExportParameter.getExportFormat(), (Object)clone.getExportFormat());
    }
}

